declare module '@sage/x3-project-management-api-partial' {
    import type {
        Account,
        AccountingCode,
        ChartOfAccounts,
        CostTypeDimensions,
        CostTypeDimensionsBinding,
        CostTypeDimensionsInput,
        Dimension,
        DimensionType,
        EntryType,
        Journal,
        Package as SageX3FinanceData$Package,
        RevenueRecognitionRules,
    } from '@sage/x3-finance-data-api';
    import type { Package as SageX3InvoicingData$Package } from '@sage/x3-invoicing-data-api';
    import type {
        Package as SageX3ManufacturingData$Package,
        WorkCenter,
        WorkCenterGroup,
        WorkCenterInput,
    } from '@sage/x3-manufacturing-data-api';
    import type {
        BomCodes,
        ContactRelationship,
        Currency,
        Customer,
        Package as SageX3MasterData$Package,
        Product,
        ProductVersion,
        SalesRep,
        UnitOfMeasure,
        WeeklyStructure,
    } from '@sage/x3-master-data-api';
    import type {
        CostType,
        CostTypeInput,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
        ProjectLinkInput,
    } from '@sage/x3-project-management-data-api';
    import type { MajorVersionStatus, Package as SageX3StockData$Package } from '@sage/x3-stock-data-api';
    import type { Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type { Company, MiscellaneousTable, Package as SageX3System$Package, Site, User } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        CreateOperation,
        DeleteOperation,
        GetDefaultsOperation,
        GetDuplicateOperation,
        Operation as Node$Operation,
        QueryOperation,
        ReadOperation,
        TextStream,
        UpdateByIdOperation,
        UpdateOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface BudgetLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        budget: Budget;
        lineNumber: integer;
        costType: CostType;
        site: Site;
        localizedDescription: string;
        unit: UnitOfMeasure;
        quantity: string;
        unitPrice: string;
        isPriceForced: boolean;
        amount: string;
        lastBudgetDate: string;
        hasNothingLeftToCommit: boolean;
        remainingQuantity: string;
        remainingUnitPrice: string;
        remainingAmount: string;
        lastEstimatedDate: string;
        lastEstimatedQuantity: string;
        lastEstimatedAmount: string;
        recordedQuantity: string;
        recordedAmount: string;
        currency: Currency;
        origin: BudgetLineOrigin;
        saleableProductLine: string;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface BudgetLineInput extends ClientNodeInput {
        project?: string;
        budget?: string;
        lineNumber?: integer | string;
        costType?: string;
        site?: string;
        localizedDescription?: string;
        unit?: string;
        quantity?: decimal | string;
        unitPrice?: decimal | string;
        isPriceForced?: boolean | string;
        amount?: decimal | string;
        lastBudgetDate?: string;
        hasNothingLeftToCommit?: boolean | string;
        remainingQuantity?: decimal | string;
        remainingUnitPrice?: decimal | string;
        remainingAmount?: decimal | string;
        lastEstimatedDate?: string;
        lastEstimatedQuantity?: decimal | string;
        lastEstimatedAmount?: decimal | string;
        recordedQuantity?: decimal | string;
        recordedAmount?: decimal | string;
        currency?: string;
        origin?: BudgetLineOrigin;
        saleableProductLine?: string;
        longComment?: TextStream;
        longDescription?: TextStream;
    }
    export interface BudgetLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        budget: Budget;
        lineNumber: integer;
        costType: CostType;
        site: Site;
        localizedDescription: string;
        unit: UnitOfMeasure;
        quantity: string;
        unitPrice: string;
        isPriceForced: boolean;
        amount: string;
        lastBudgetDate: string;
        hasNothingLeftToCommit: boolean;
        remainingQuantity: string;
        remainingUnitPrice: string;
        remainingAmount: string;
        lastEstimatedDate: string;
        lastEstimatedQuantity: string;
        lastEstimatedAmount: string;
        recordedQuantity: string;
        recordedAmount: string;
        currency: Currency;
        origin: BudgetLineOrigin;
        saleableProductLine: string;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface BudgetLine$Lookups {
        project: QueryOperation<Project>;
        budget: QueryOperation<Budget>;
        costType: QueryOperation<CostType>;
        site: QueryOperation<Site>;
        unit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
    }
    export interface BudgetLine$Operations {
        query: QueryOperation<BudgetLine>;
        read: ReadOperation<BudgetLine>;
        aggregate: {
            read: AggregateReadOperation<BudgetLine>;
            query: AggregateQueryOperation<BudgetLine>;
        };
        lookups(dataOrId: string | { data: BudgetLineInput }): BudgetLine$Lookups;
        getDefaults: GetDefaultsOperation<BudgetLine>;
    }
    export interface Budget extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        code: string;
        site: Site;
        sortKey: integer;
        suspensionDate: string;
        closingDate: string;
        deliveryDate: string;
        parent: Budget;
        status: ProjectBudgetStatus;
        isElementary: boolean;
        isChargeable: boolean;
        startDate: string;
        endDate: string;
        sequenceNumber: string;
        responsiblePerson: ProjectUser;
        estimatedProgress: string;
        progressRange: MiscellaneousTable;
        progressDate: string;
        progressMethod: EstimationMethodUsed;
        billingMode: BillingMode;
        timeCategory: TimeCategory;
        source: ProjectLink;
        lines: ClientCollection<BudgetLine>;
        projectLink: ProjectLink;
        isActive: boolean;
        localizedDescription: string;
        localizedShortDescription: string;
        longComment: TextStream;
        longDescription: TextStream;
        type: ProjectAllocationType;
    }
    export interface BudgetInput extends ClientNodeInput {
        project?: string;
        code?: string;
        site?: string;
        sortKey?: integer | string;
        suspensionDate?: string;
        closingDate?: string;
        deliveryDate?: string;
        parent?: string;
        status?: ProjectBudgetStatus;
        isElementary?: boolean | string;
        isChargeable?: boolean | string;
        startDate?: string;
        endDate?: string;
        sequenceNumber?: string;
        responsiblePerson?: string;
        estimatedProgress?: decimal | string;
        progressRange?: string;
        progressDate?: string;
        progressMethod?: EstimationMethodUsed;
        billingMode?: BillingMode;
        timeCategory?: string;
        source?: string;
        lines?: Partial<BudgetLineInput>[];
        projectLink?: string;
        isActive?: boolean | string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        longComment?: TextStream;
        longDescription?: TextStream;
        type?: ProjectAllocationType;
    }
    export interface BudgetBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        code: string;
        site: Site;
        sortKey: integer;
        suspensionDate: string;
        closingDate: string;
        deliveryDate: string;
        parent: Budget;
        status: ProjectBudgetStatus;
        isElementary: boolean;
        isChargeable: boolean;
        startDate: string;
        endDate: string;
        sequenceNumber: string;
        responsiblePerson: ProjectUser;
        estimatedProgress: string;
        progressRange: MiscellaneousTable;
        progressDate: string;
        progressMethod: EstimationMethodUsed;
        billingMode: BillingMode;
        timeCategory: TimeCategory;
        source: ProjectLink;
        lines: ClientCollection<BudgetLine>;
        projectLink: ProjectLink;
        isActive: boolean;
        localizedDescription: string;
        localizedShortDescription: string;
        longComment: TextStream;
        longDescription: TextStream;
        type: ProjectAllocationType;
    }
    export interface Budget$Lookups {
        project: QueryOperation<Project>;
        site: QueryOperation<Site>;
        parent: QueryOperation<Budget>;
        responsiblePerson: QueryOperation<ProjectUser>;
        progressRange: QueryOperation<MiscellaneousTable>;
        timeCategory: QueryOperation<TimeCategory>;
        source: QueryOperation<ProjectLink>;
        projectLink: QueryOperation<ProjectLink>;
    }
    export interface Budget$Operations {
        query: QueryOperation<Budget>;
        read: ReadOperation<Budget>;
        aggregate: {
            read: AggregateReadOperation<Budget>;
            query: AggregateQueryOperation<Budget>;
        };
        create: CreateOperation<BudgetInput, Budget>;
        getDuplicate: GetDuplicateOperation<Budget>;
        update: UpdateOperation<BudgetInput, Budget>;
        updateById: UpdateByIdOperation<BudgetInput, Budget>;
        delete: DeleteOperation<{}>;
        deleteById: DeleteOperation<string>;
        lookups(dataOrId: string | { data: BudgetInput }): Budget$Lookups;
        getDefaults: GetDefaultsOperation<Budget>;
    }
    export interface CostDate extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        costType: CostType;
        rateActivationDate: string;
        unitPrice: string;
    }
    export interface CostDateInput extends ClientNodeInput {
        costType?: string;
        rateActivationDate?: string;
        unitPrice?: decimal | string;
    }
    export interface CostDateBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        costType: CostType;
        rateActivationDate: string;
        unitPrice: string;
    }
    export interface CostDate$Lookups {
        costType: QueryOperation<CostType>;
    }
    export interface CostDate$Operations {
        query: QueryOperation<CostDate>;
        read: ReadOperation<CostDate>;
        aggregate: {
            read: AggregateReadOperation<CostDate>;
            query: AggregateQueryOperation<CostDate>;
        };
        lookups(dataOrId: string | { data: CostDateInput }): CostDate$Lookups;
        getDefaults: GetDefaultsOperation<CostDate>;
    }
    export interface CostGroupLink extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        costType: CostType;
        costGroupType: CostGroupType;
        material: MaterialCostGroup;
        labor: DimensionCostGroup;
        machine: DimensionCostGroup;
    }
    export interface CostGroupLinkInput extends ClientNodeInput {
        costType?: string;
        costGroupType?: CostGroupType;
        material?: MaterialCostGroup;
        labor?: DimensionCostGroup;
        machine?: DimensionCostGroup;
    }
    export interface CostGroupLinkBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        costType: CostType;
        costGroupType: CostGroupType;
        material: MaterialCostGroup;
        labor: DimensionCostGroup;
        machine: DimensionCostGroup;
    }
    export interface CostGroupLink$Lookups {
        costType: QueryOperation<CostType>;
    }
    export interface CostGroupLink$Operations {
        query: QueryOperation<CostGroupLink>;
        read: ReadOperation<CostGroupLink>;
        aggregate: {
            read: AggregateReadOperation<CostGroupLink>;
            query: AggregateQueryOperation<CostGroupLink>;
        };
        lookups(dataOrId: string | { data: CostGroupLinkInput }): CostGroupLink$Lookups;
        getDefaults: GetDefaultsOperation<CostGroupLink>;
    }
    export interface CostStructureReportingSnapshot extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        financialView: MiscellaneousTable;
        project: ProjectLink;
        lineNumber: integer;
        parent: Budget;
        budget: Budget;
        budgetSortKey: integer;
        costTypeGroup: MiscellaneousTable;
        costTypeGroupSortKey: integer;
        costType: CostType;
        budgetQuantity: string;
        budgetAmount: string;
        quantity1: string;
        amount1: string;
        quantity2: string;
        amount2: string;
        quantity3: string;
        amount3: string;
        quantity4: string;
        amount4: string;
        quantity5: string;
        amount5: string;
        totalQuantity: string;
        totalAmount: string;
        remainingQuantity: string;
        remainingAmount: string;
        marginQuantity: string;
        marginAmount: string;
        percentageQuantity: string;
        percentageAmount: string;
        totalEstimationQuantity: string;
        totalEstimationAmount: string;
        freeQuantity1: string;
        freeAmount1: string;
        freeQuantity2: string;
        freeAmount2: string;
        freeQuantity3: string;
        freeAmount3: string;
        freeQuantity4: string;
        freeAmount4: string;
        freeQuantity5: string;
        freeAmount5: string;
        budgetRatio: string;
        budgetPercentage: string;
        totalRatio: string;
        totalPercentage: string;
        wipQuantity: string;
        wipAmount: string;
        unit: UnitOfMeasure;
        currency: Currency;
    }
    export interface CostStructureReportingSnapshotInput extends ClientNodeInput {
        id?: string;
        financialView?: string;
        project?: string;
        lineNumber?: integer | string;
        parent?: string;
        budget?: string;
        budgetSortKey?: integer | string;
        costTypeGroup?: string;
        costTypeGroupSortKey?: integer | string;
        costType?: string;
        budgetQuantity?: decimal | string;
        budgetAmount?: decimal | string;
        quantity1?: decimal | string;
        amount1?: decimal | string;
        quantity2?: decimal | string;
        amount2?: decimal | string;
        quantity3?: decimal | string;
        amount3?: decimal | string;
        quantity4?: decimal | string;
        amount4?: decimal | string;
        quantity5?: decimal | string;
        amount5?: decimal | string;
        totalQuantity?: decimal | string;
        totalAmount?: decimal | string;
        remainingQuantity?: decimal | string;
        remainingAmount?: decimal | string;
        marginQuantity?: decimal | string;
        marginAmount?: decimal | string;
        percentageQuantity?: decimal | string;
        percentageAmount?: decimal | string;
        totalEstimationQuantity?: decimal | string;
        totalEstimationAmount?: decimal | string;
        freeQuantity1?: decimal | string;
        freeAmount1?: decimal | string;
        freeQuantity2?: decimal | string;
        freeAmount2?: decimal | string;
        freeQuantity3?: decimal | string;
        freeAmount3?: decimal | string;
        freeQuantity4?: decimal | string;
        freeAmount4?: decimal | string;
        freeQuantity5?: decimal | string;
        freeAmount5?: decimal | string;
        budgetRatio?: decimal | string;
        budgetPercentage?: decimal | string;
        totalRatio?: decimal | string;
        totalPercentage?: decimal | string;
        wipQuantity?: decimal | string;
        wipAmount?: decimal | string;
        unit?: string;
        currency?: string;
    }
    export interface CostStructureReportingSnapshotBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        financialView: MiscellaneousTable;
        project: ProjectLink;
        lineNumber: integer;
        parent: Budget;
        budget: Budget;
        budgetSortKey: integer;
        costTypeGroup: MiscellaneousTable;
        costTypeGroupSortKey: integer;
        costType: CostType;
        budgetQuantity: string;
        budgetAmount: string;
        quantity1: string;
        amount1: string;
        quantity2: string;
        amount2: string;
        quantity3: string;
        amount3: string;
        quantity4: string;
        amount4: string;
        quantity5: string;
        amount5: string;
        totalQuantity: string;
        totalAmount: string;
        remainingQuantity: string;
        remainingAmount: string;
        marginQuantity: string;
        marginAmount: string;
        percentageQuantity: string;
        percentageAmount: string;
        totalEstimationQuantity: string;
        totalEstimationAmount: string;
        freeQuantity1: string;
        freeAmount1: string;
        freeQuantity2: string;
        freeAmount2: string;
        freeQuantity3: string;
        freeAmount3: string;
        freeQuantity4: string;
        freeAmount4: string;
        freeQuantity5: string;
        freeAmount5: string;
        budgetRatio: string;
        budgetPercentage: string;
        totalRatio: string;
        totalPercentage: string;
        wipQuantity: string;
        wipAmount: string;
        unit: UnitOfMeasure;
        currency: Currency;
    }
    export interface CostStructureReportingSnapshot$Lookups {
        financialView: QueryOperation<MiscellaneousTable>;
        project: QueryOperation<ProjectLink>;
        parent: QueryOperation<Budget>;
        budget: QueryOperation<Budget>;
        costTypeGroup: QueryOperation<MiscellaneousTable>;
        costType: QueryOperation<CostType>;
        unit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
    }
    export interface CostStructureReportingSnapshot$Operations {
        query: QueryOperation<CostStructureReportingSnapshot>;
        read: ReadOperation<CostStructureReportingSnapshot>;
        aggregate: {
            read: AggregateReadOperation<CostStructureReportingSnapshot>;
            query: AggregateQueryOperation<CostStructureReportingSnapshot>;
        };
        lookups(
            dataOrId: string | { data: CostStructureReportingSnapshotInput },
        ): CostStructureReportingSnapshot$Lookups;
        getDefaults: GetDefaultsOperation<CostStructureReportingSnapshot>;
    }
    export interface CostTypeReportingSnapshot extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        financialView: MiscellaneousTable;
        project: ProjectLink;
        lineNumber: integer;
        parent: Budget;
        budget: Budget;
        costTypeGroup: MiscellaneousTable;
        costTypeGroupSortKey: integer;
        costType: CostType;
        budgetQuantity: string;
        budgetAmount: string;
        quantity1: string;
        amount1: string;
        quantity2: string;
        amount2: string;
        quantity3: string;
        amount3: string;
        quantity4: string;
        amount4: string;
        quantity5: string;
        amount5: string;
        totalQuantity: string;
        totalAmount: string;
        remainingQuantity: string;
        remainingAmount: string;
        marginQuantity: string;
        marginAmount: string;
        percentageQuantity: string;
        percentageAmount: string;
        totalEstimationQuantity: string;
        totalEstimationAmount: string;
        freeQuantity1: string;
        freeAmount1: string;
        freeQuantity2: string;
        freeAmount2: string;
        freeQuantity3: string;
        freeAmount3: string;
        freeQuantity4: string;
        freeAmount4: string;
        freeQuantity5: string;
        freeAmount5: string;
        budgetRatio: string;
        budgetPercentage: string;
        totalRatio: string;
        totalPercentage: string;
        wipQuantity: string;
        wipAmount: string;
        unit: UnitOfMeasure;
        currency: Currency;
    }
    export interface CostTypeReportingSnapshotInput extends ClientNodeInput {
        id?: string;
        financialView?: string;
        project?: string;
        lineNumber?: integer | string;
        parent?: string;
        budget?: string;
        costTypeGroup?: string;
        costTypeGroupSortKey?: integer | string;
        costType?: string;
        budgetQuantity?: decimal | string;
        budgetAmount?: decimal | string;
        quantity1?: decimal | string;
        amount1?: decimal | string;
        quantity2?: decimal | string;
        amount2?: decimal | string;
        quantity3?: decimal | string;
        amount3?: decimal | string;
        quantity4?: decimal | string;
        amount4?: decimal | string;
        quantity5?: decimal | string;
        amount5?: decimal | string;
        totalQuantity?: decimal | string;
        totalAmount?: decimal | string;
        remainingQuantity?: decimal | string;
        remainingAmount?: decimal | string;
        marginQuantity?: decimal | string;
        marginAmount?: decimal | string;
        percentageQuantity?: decimal | string;
        percentageAmount?: decimal | string;
        totalEstimationQuantity?: decimal | string;
        totalEstimationAmount?: decimal | string;
        freeQuantity1?: decimal | string;
        freeAmount1?: decimal | string;
        freeQuantity2?: decimal | string;
        freeAmount2?: decimal | string;
        freeQuantity3?: decimal | string;
        freeAmount3?: decimal | string;
        freeQuantity4?: decimal | string;
        freeAmount4?: decimal | string;
        freeQuantity5?: decimal | string;
        freeAmount5?: decimal | string;
        budgetRatio?: decimal | string;
        budgetPercentage?: decimal | string;
        totalRatio?: decimal | string;
        totalPercentage?: decimal | string;
        wipQuantity?: decimal | string;
        wipAmount?: decimal | string;
        unit?: string;
        currency?: string;
    }
    export interface CostTypeReportingSnapshotBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        financialView: MiscellaneousTable;
        project: ProjectLink;
        lineNumber: integer;
        parent: Budget;
        budget: Budget;
        costTypeGroup: MiscellaneousTable;
        costTypeGroupSortKey: integer;
        costType: CostType;
        budgetQuantity: string;
        budgetAmount: string;
        quantity1: string;
        amount1: string;
        quantity2: string;
        amount2: string;
        quantity3: string;
        amount3: string;
        quantity4: string;
        amount4: string;
        quantity5: string;
        amount5: string;
        totalQuantity: string;
        totalAmount: string;
        remainingQuantity: string;
        remainingAmount: string;
        marginQuantity: string;
        marginAmount: string;
        percentageQuantity: string;
        percentageAmount: string;
        totalEstimationQuantity: string;
        totalEstimationAmount: string;
        freeQuantity1: string;
        freeAmount1: string;
        freeQuantity2: string;
        freeAmount2: string;
        freeQuantity3: string;
        freeAmount3: string;
        freeQuantity4: string;
        freeAmount4: string;
        freeQuantity5: string;
        freeAmount5: string;
        budgetRatio: string;
        budgetPercentage: string;
        totalRatio: string;
        totalPercentage: string;
        wipQuantity: string;
        wipAmount: string;
        unit: UnitOfMeasure;
        currency: Currency;
    }
    export interface CostTypeReportingSnapshot$Lookups {
        financialView: QueryOperation<MiscellaneousTable>;
        project: QueryOperation<ProjectLink>;
        parent: QueryOperation<Budget>;
        budget: QueryOperation<Budget>;
        costTypeGroup: QueryOperation<MiscellaneousTable>;
        costType: QueryOperation<CostType>;
        unit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
    }
    export interface CostTypeReportingSnapshot$Operations {
        query: QueryOperation<CostTypeReportingSnapshot>;
        read: ReadOperation<CostTypeReportingSnapshot>;
        aggregate: {
            read: AggregateReadOperation<CostTypeReportingSnapshot>;
            query: AggregateQueryOperation<CostTypeReportingSnapshot>;
        };
        lookups(dataOrId: string | { data: CostTypeReportingSnapshotInput }): CostTypeReportingSnapshot$Lookups;
        getDefaults: GetDefaultsOperation<CostTypeReportingSnapshot>;
    }
    export interface FinancialOverviewStructure extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        financialView: MiscellaneousTable;
        columnSequence: string;
        columnContent: string;
        subColumn1Title: string;
        subColumn2Title: string;
        subColumn1Type: QuantityAmount;
        subColumn2Type: QuantityAmount;
        display: boolean;
    }
    export interface FinancialOverviewStructureInput extends ClientNodeInput {
        financialView?: string;
        columnSequence?: string;
        columnContent?: string;
        subColumn1Title?: string;
        subColumn2Title?: string;
        subColumn1Type?: QuantityAmount;
        subColumn2Type?: QuantityAmount;
        display?: boolean | string;
    }
    export interface FinancialOverviewStructureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        financialView: MiscellaneousTable;
        columnSequence: string;
        columnContent: string;
        subColumn1Title: string;
        subColumn2Title: string;
        subColumn1Type: QuantityAmount;
        subColumn2Type: QuantityAmount;
        display: boolean;
    }
    export interface FinancialOverviewStructure$Lookups {
        financialView: QueryOperation<MiscellaneousTable>;
    }
    export interface FinancialOverviewStructure$Operations {
        query: QueryOperation<FinancialOverviewStructure>;
        read: ReadOperation<FinancialOverviewStructure>;
        aggregate: {
            read: AggregateReadOperation<FinancialOverviewStructure>;
            query: AggregateQueryOperation<FinancialOverviewStructure>;
        };
        lookups(dataOrId: string | { data: FinancialOverviewStructureInput }): FinancialOverviewStructure$Lookups;
        getDefaults: GetDefaultsOperation<FinancialOverviewStructure>;
    }
    export interface OperationAssignment extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        lineNumber: integer;
        employee: ProjectUser;
        localizedDescription: string;
        unit: UnitOfMeasure;
        plannedLoad: string;
        consumedLoad: string;
        remainingLoad: string;
        currency: Currency;
        hourlyRate: string;
        laborRate: string;
        startDate: string;
        endDate: string;
        startTime: string;
        endTime: string;
        timeCategory: TimeCategory;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface OperationAssignmentInput extends ClientNodeInput {
        project?: string;
        task?: string;
        operation?: integer | string;
        firstOperationSplit?: integer | string;
        lineNumber?: integer | string;
        employee?: string;
        localizedDescription?: string;
        unit?: string;
        plannedLoad?: decimal | string;
        consumedLoad?: decimal | string;
        remainingLoad?: decimal | string;
        currency?: string;
        hourlyRate?: decimal | string;
        laborRate?: decimal | string;
        startDate?: string;
        endDate?: string;
        startTime?: string;
        endTime?: string;
        timeCategory?: string;
        longComment?: TextStream;
        longDescription?: TextStream;
    }
    export interface OperationAssignmentBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        lineNumber: integer;
        employee: ProjectUser;
        localizedDescription: string;
        unit: UnitOfMeasure;
        plannedLoad: string;
        consumedLoad: string;
        remainingLoad: string;
        currency: Currency;
        hourlyRate: string;
        laborRate: string;
        startDate: string;
        endDate: string;
        startTime: string;
        endTime: string;
        timeCategory: TimeCategory;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface OperationAssignment$Lookups {
        project: QueryOperation<Project>;
        task: QueryOperation<Task>;
        operation: QueryOperation<Operation>;
        employee: QueryOperation<ProjectUser>;
        unit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
        timeCategory: QueryOperation<TimeCategory>;
    }
    export interface OperationAssignment$Operations {
        query: QueryOperation<OperationAssignment>;
        read: ReadOperation<OperationAssignment>;
        aggregate: {
            read: AggregateReadOperation<OperationAssignment>;
            query: AggregateQueryOperation<OperationAssignment>;
        };
        lookups(dataOrId: string | { data: OperationAssignmentInput }): OperationAssignment$Lookups;
        getDefaults: GetDefaultsOperation<OperationAssignment>;
    }
    export interface OperationPrecedenceLink extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        lineNumber: integer;
        linkedOperation: Operation;
        linkedOperationSplit: integer;
        linkType: OperationsLinkType;
        constraintType: ConstraintType;
        lagDays: integer;
    }
    export interface OperationPrecedenceLinkInput extends ClientNodeInput {
        project?: string;
        task?: string;
        operation?: integer | string;
        firstOperationSplit?: integer | string;
        lineNumber?: integer | string;
        linkedOperation?: integer | string;
        linkedOperationSplit?: integer | string;
        linkType?: OperationsLinkType;
        constraintType?: ConstraintType;
        lagDays?: integer | string;
    }
    export interface OperationPrecedenceLinkBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        lineNumber: integer;
        linkedOperation: Operation;
        linkedOperationSplit: integer;
        linkType: OperationsLinkType;
        constraintType: ConstraintType;
        lagDays: integer;
    }
    export interface OperationPrecedenceLink$Lookups {
        project: QueryOperation<ProjectLink>;
        task: QueryOperation<Task>;
        operation: QueryOperation<Operation>;
        linkedOperation: QueryOperation<Operation>;
    }
    export interface OperationPrecedenceLink$Operations {
        query: QueryOperation<OperationPrecedenceLink>;
        read: ReadOperation<OperationPrecedenceLink>;
        aggregate: {
            read: AggregateReadOperation<OperationPrecedenceLink>;
            query: AggregateQueryOperation<OperationPrecedenceLink>;
        };
        lookups(dataOrId: string | { data: OperationPrecedenceLinkInput }): OperationPrecedenceLink$Lookups;
        getDefaults: GetDefaultsOperation<OperationPrecedenceLink>;
    }
    export interface Operation extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        number: integer;
        firstOperationSplit: integer;
        site: Site;
        workCenterLaborResource1: WorkCenter;
        workCenterLaborResource2: WorkCenter;
        currency: Currency;
        status: OperationStatus;
        startDate: string;
        endDate: string;
        duration: integer;
        localizedDescription: string;
        unit: UnitOfMeasure;
        numberOfResource1: integer;
        numberOfResource2: integer;
        plannedLoad: string;
        consumedLoad: string;
        remainingLoad: string;
        hourlyRate: string;
        laborRate: string;
        actualStartDate: string;
        actualEndDate: string;
        closingDate: string;
        suspensionDate: string;
        timeCategory: TimeCategory;
        saleableProductLine: string;
        assignments: ClientCollection<OperationAssignment>;
        precedenceLinks: ClientCollection<OperationPrecedenceLink>;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface OperationInput extends ClientNodeInput {
        project?: string;
        task?: string;
        number?: integer | string;
        firstOperationSplit?: integer | string;
        site?: string;
        workCenterLaborResource1?: string;
        workCenterLaborResource2?: string;
        currency?: string;
        status?: OperationStatus;
        startDate?: string;
        endDate?: string;
        duration?: integer | string;
        localizedDescription?: string;
        unit?: string;
        numberOfResource1?: integer | string;
        numberOfResource2?: integer | string;
        plannedLoad?: decimal | string;
        consumedLoad?: decimal | string;
        remainingLoad?: decimal | string;
        hourlyRate?: decimal | string;
        laborRate?: decimal | string;
        actualStartDate?: string;
        actualEndDate?: string;
        closingDate?: string;
        suspensionDate?: string;
        timeCategory?: string;
        saleableProductLine?: string;
        assignments?: Partial<OperationAssignmentInput>[];
        precedenceLinks?: Partial<OperationPrecedenceLinkInput>[];
        longComment?: TextStream;
        longDescription?: TextStream;
    }
    export interface OperationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        number: integer;
        firstOperationSplit: integer;
        site: Site;
        workCenterLaborResource1: WorkCenter;
        workCenterLaborResource2: WorkCenter;
        currency: Currency;
        status: OperationStatus;
        startDate: string;
        endDate: string;
        duration: integer;
        localizedDescription: string;
        unit: UnitOfMeasure;
        numberOfResource1: integer;
        numberOfResource2: integer;
        plannedLoad: string;
        consumedLoad: string;
        remainingLoad: string;
        hourlyRate: string;
        laborRate: string;
        actualStartDate: string;
        actualEndDate: string;
        closingDate: string;
        suspensionDate: string;
        timeCategory: TimeCategory;
        saleableProductLine: string;
        assignments: ClientCollection<OperationAssignment>;
        precedenceLinks: ClientCollection<OperationPrecedenceLink>;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface Operation$Lookups {
        project: QueryOperation<Project>;
        task: QueryOperation<Task>;
        site: QueryOperation<Site>;
        workCenterLaborResource1: QueryOperation<WorkCenter>;
        workCenterLaborResource2: QueryOperation<WorkCenter>;
        currency: QueryOperation<Currency>;
        unit: QueryOperation<UnitOfMeasure>;
        timeCategory: QueryOperation<TimeCategory>;
    }
    export interface Operation$Operations {
        query: QueryOperation<Operation>;
        read: ReadOperation<Operation>;
        aggregate: {
            read: AggregateReadOperation<Operation>;
            query: AggregateQueryOperation<Operation>;
        };
        lookups(dataOrId: string | { data: OperationInput }): Operation$Lookups;
        getDefaults: GetDefaultsOperation<Operation>;
    }
    export interface PjmProjectDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        project: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface PjmProjectDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        project?: string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface PjmProjectDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        project: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface PjmProjectDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface PjmProjectDimensions$Operations {
        query: QueryOperation<PjmProjectDimensions>;
        read: ReadOperation<PjmProjectDimensions>;
        aggregate: {
            read: AggregateReadOperation<PjmProjectDimensions>;
            query: AggregateQueryOperation<PjmProjectDimensions>;
        };
        lookups(dataOrId: string | { data: PjmProjectDimensionsInput }): PjmProjectDimensions$Lookups;
        getDefaults: GetDefaultsOperation<PjmProjectDimensions>;
    }
    export interface ProjectAssignment extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        employee: ProjectUser;
        role: MiscellaneousTable;
    }
    export interface ProjectAssignmentInput extends ClientNodeInput {
        project?: string;
        employee?: string;
        role?: string;
    }
    export interface ProjectAssignmentBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        employee: ProjectUser;
        role: MiscellaneousTable;
    }
    export interface ProjectAssignment$Lookups {
        project: QueryOperation<ProjectLink>;
        employee: QueryOperation<ProjectUser>;
        role: QueryOperation<MiscellaneousTable>;
    }
    export interface ProjectAssignment$Operations {
        query: QueryOperation<ProjectAssignment>;
        read: ReadOperation<ProjectAssignment>;
        aggregate: {
            read: AggregateReadOperation<ProjectAssignment>;
            query: AggregateQueryOperation<ProjectAssignment>;
        };
        lookups(dataOrId: string | { data: ProjectAssignmentInput }): ProjectAssignment$Lookups;
        getDefaults: GetDefaultsOperation<ProjectAssignment>;
    }
    export interface ProjectUserCapacityVariation extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: ProjectUser;
        lineNumber: integer;
        startDate: string;
        endDate: string;
        reason: MiscellaneousTable;
        weeklyStructure: WeeklyStructure;
    }
    export interface ProjectUserCapacityVariationInput extends ClientNodeInput {
        employee?: string;
        lineNumber?: integer | string;
        startDate?: string;
        endDate?: string;
        reason?: string;
        weeklyStructure?: string;
    }
    export interface ProjectUserCapacityVariationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: ProjectUser;
        lineNumber: integer;
        startDate: string;
        endDate: string;
        reason: MiscellaneousTable;
        weeklyStructure: WeeklyStructure;
    }
    export interface ProjectUserCapacityVariation$Lookups {
        employee: QueryOperation<ProjectUser>;
        reason: QueryOperation<MiscellaneousTable>;
        weeklyStructure: QueryOperation<WeeklyStructure>;
    }
    export interface ProjectUserCapacityVariation$Operations {
        query: QueryOperation<ProjectUserCapacityVariation>;
        read: ReadOperation<ProjectUserCapacityVariation>;
        aggregate: {
            read: AggregateReadOperation<ProjectUserCapacityVariation>;
            query: AggregateQueryOperation<ProjectUserCapacityVariation>;
        };
        lookups(dataOrId: string | { data: ProjectUserCapacityVariationInput }): ProjectUserCapacityVariation$Lookups;
        getDefaults: GetDefaultsOperation<ProjectUserCapacityVariation>;
    }
    export interface ProjectUser extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: User;
        role: MiscellaneousTable;
        isTimeEntryEmployee: boolean;
        isTimeEntryAdministrator: boolean;
        hourlyRate: string;
        currency: Currency;
        costType: CostType;
        isActiveEmployeeOnProjects: boolean;
        weeklyStructure: WeeklyStructure;
        site: Site;
        timeCategory: TimeCategory;
        lines: ClientCollection<ProjectUserCapacityVariation>;
    }
    export interface ProjectUserInput extends ClientNodeInput {
        employee?: string;
        role?: string;
        isTimeEntryEmployee?: boolean | string;
        isTimeEntryAdministrator?: boolean | string;
        hourlyRate?: decimal | string;
        currency?: string;
        costType?: string;
        isActiveEmployeeOnProjects?: boolean | string;
        weeklyStructure?: string;
        site?: string;
        timeCategory?: string;
    }
    export interface ProjectUserBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: User;
        role: MiscellaneousTable;
        isTimeEntryEmployee: boolean;
        isTimeEntryAdministrator: boolean;
        hourlyRate: string;
        currency: Currency;
        costType: CostType;
        isActiveEmployeeOnProjects: boolean;
        weeklyStructure: WeeklyStructure;
        site: Site;
        timeCategory: TimeCategory;
        lines: ClientCollection<ProjectUserCapacityVariation>;
    }
    export interface ProjectUser$Lookups {
        employee: QueryOperation<User>;
        role: QueryOperation<MiscellaneousTable>;
        currency: QueryOperation<Currency>;
        costType: QueryOperation<CostType>;
        weeklyStructure: QueryOperation<WeeklyStructure>;
        site: QueryOperation<Site>;
        timeCategory: QueryOperation<TimeCategory>;
    }
    export interface ProjectUser$Operations {
        query: QueryOperation<ProjectUser>;
        read: ReadOperation<ProjectUser>;
        aggregate: {
            read: AggregateReadOperation<ProjectUser>;
            query: AggregateQueryOperation<ProjectUser>;
        };
        lookups(dataOrId: string | { data: ProjectUserInput }): ProjectUser$Lookups;
        getDefaults: GetDefaultsOperation<ProjectUser>;
    }
    export interface Project extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: MiscellaneousTable;
        externalIdentifier: string;
        isClosed: boolean;
        salesRepresentative: SalesRep;
        rateType: ExchangeRateType;
        customer: Customer;
        contact: ContactRelationship;
        currency: Currency;
        site: Site;
        marketingCampaign: string;
        marketingOperation: string;
        marketingOperationType: string;
        origin: ProjectOrigins;
        originalDocument: string;
        originalDocumentLine: integer;
        creationTime: string;
        originalMethod: OriginType;
        openingDate: string;
        employees: ClientCollection<ProjectAssignment>;
        projectLink: ProjectLink;
        tasks: ClientCollection<Task>;
        budgets: ClientCollection<Budget>;
        accountingCode: AccountingCode;
        billingMode: BillingMode;
        closingDate: string;
        deliveryDate: string;
        dimensions: ClientCollection<PjmProjectDimensions>;
        dueDate: string;
        duration: integer;
        endDate: string;
        estimatedProgressPercentage: string;
        estimatedRevenueAtCompletion: string;
        isActive: boolean;
        isBudgetCreatedAutomatically: boolean;
        isIndirectCostCalculated: boolean;
        isIntermediateLevelBudgetingAllowed: boolean;
        isInternal: boolean;
        isProvisional: boolean;
        isTemplate: boolean;
        launchingDate: string;
        localizedDescription: string;
        localizedShortDescription: string;
        longComment: TextStream;
        longDescription: TextStream;
        operatingSite: Site;
        overviewCurrency: Currency;
        progressEstimationDate: string;
        progressEstimationMethod: EstimationMethodUsed;
        progressRange: MiscellaneousTable;
        projectStatus: ProjectStatus;
        responsiblePerson: ProjectUser;
        revenueEstimationDate: string;
        revenueEstimationMethod: EstimationMethodUsed;
        revenueRecognitionExtractionMethod: CalculationMethodUsed;
        revenueRecognitionRule: RevenueRecognitionRules;
        source: ProjectLink;
        startDate: string;
        suspensionDate: string;
        type: ProjectAllocationType;
    }
    export interface ProjectInput extends ClientNodeInput {
        id?: string;
        category?: string;
        externalIdentifier?: string;
        isClosed?: boolean | string;
        salesRepresentative?: string;
        rateType?: ExchangeRateType;
        customer?: string;
        contact?: string;
        currency?: string;
        site?: string;
        marketingCampaign?: string;
        marketingOperation?: string;
        marketingOperationType?: string;
        origin?: ProjectOrigins;
        originalDocument?: string;
        originalDocumentLine?: integer | string;
        creationTime?: string;
        originalMethod?: OriginType;
        openingDate?: string;
        employees?: Partial<ProjectAssignmentInput>[];
        projectLink?: string;
        accountingCode?: string;
        billingMode?: BillingMode;
        closingDate?: string;
        deliveryDate?: string;
        dimensions?: Partial<PjmProjectDimensionsInput>[];
        dueDate?: string;
        duration?: integer | string;
        endDate?: string;
        estimatedProgressPercentage?: decimal | string;
        estimatedRevenueAtCompletion?: decimal | string;
        isActive?: boolean | string;
        isBudgetCreatedAutomatically?: boolean | string;
        isIndirectCostCalculated?: boolean | string;
        isIntermediateLevelBudgetingAllowed?: boolean | string;
        isInternal?: boolean | string;
        isProvisional?: boolean | string;
        isTemplate?: boolean | string;
        launchingDate?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        longComment?: TextStream;
        longDescription?: TextStream;
        operatingSite?: string;
        overviewCurrency?: string;
        progressEstimationDate?: string;
        progressEstimationMethod?: EstimationMethodUsed;
        progressRange?: string;
        projectStatus?: ProjectStatus;
        responsiblePerson?: string;
        revenueEstimationDate?: string;
        revenueEstimationMethod?: EstimationMethodUsed;
        revenueRecognitionExtractionMethod?: CalculationMethodUsed;
        revenueRecognitionRule?: string;
        source?: string;
        startDate?: string;
        suspensionDate?: string;
        type?: ProjectAllocationType;
    }
    export interface ProjectBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: MiscellaneousTable;
        externalIdentifier: string;
        isClosed: boolean;
        salesRepresentative: SalesRep;
        rateType: ExchangeRateType;
        customer: Customer;
        contact: ContactRelationship;
        currency: Currency;
        site: Site;
        marketingCampaign: string;
        marketingOperation: string;
        marketingOperationType: string;
        origin: ProjectOrigins;
        originalDocument: string;
        originalDocumentLine: integer;
        creationTime: string;
        originalMethod: OriginType;
        openingDate: string;
        employees: ClientCollection<ProjectAssignment>;
        projectLink: ProjectLink;
        tasks: ClientCollection<Task>;
        budgets: ClientCollection<Budget>;
        accountingCode: AccountingCode;
        billingMode: BillingMode;
        closingDate: string;
        deliveryDate: string;
        dimensions: ClientCollection<PjmProjectDimensions>;
        dueDate: string;
        duration: integer;
        endDate: string;
        estimatedProgressPercentage: string;
        estimatedRevenueAtCompletion: string;
        isActive: boolean;
        isBudgetCreatedAutomatically: boolean;
        isIndirectCostCalculated: boolean;
        isIntermediateLevelBudgetingAllowed: boolean;
        isInternal: boolean;
        isProvisional: boolean;
        isTemplate: boolean;
        launchingDate: string;
        localizedDescription: string;
        localizedShortDescription: string;
        longComment: TextStream;
        longDescription: TextStream;
        operatingSite: Site;
        overviewCurrency: Currency;
        progressEstimationDate: string;
        progressEstimationMethod: EstimationMethodUsed;
        progressRange: MiscellaneousTable;
        projectStatus: ProjectStatus;
        responsiblePerson: ProjectUser;
        revenueEstimationDate: string;
        revenueEstimationMethod: EstimationMethodUsed;
        revenueRecognitionExtractionMethod: CalculationMethodUsed;
        revenueRecognitionRule: RevenueRecognitionRules;
        source: ProjectLink;
        startDate: string;
        suspensionDate: string;
        type: ProjectAllocationType;
    }
    export interface Project$Lookups {
        category: QueryOperation<MiscellaneousTable>;
        salesRepresentative: QueryOperation<SalesRep>;
        customer: QueryOperation<Customer>;
        contact: QueryOperation<ContactRelationship>;
        currency: QueryOperation<Currency>;
        site: QueryOperation<Site>;
        projectLink: QueryOperation<ProjectLink>;
        accountingCode: QueryOperation<AccountingCode>;
        operatingSite: QueryOperation<Site>;
        overviewCurrency: QueryOperation<Currency>;
        progressRange: QueryOperation<MiscellaneousTable>;
        responsiblePerson: QueryOperation<ProjectUser>;
        revenueRecognitionRule: QueryOperation<RevenueRecognitionRules>;
        source: QueryOperation<ProjectLink>;
    }
    export interface Project$Operations {
        query: QueryOperation<Project>;
        read: ReadOperation<Project>;
        aggregate: {
            read: AggregateReadOperation<Project>;
            query: AggregateQueryOperation<Project>;
        };
        create: CreateOperation<ProjectInput, Project>;
        getDuplicate: GetDuplicateOperation<Project>;
        update: UpdateOperation<ProjectInput, Project>;
        updateById: UpdateByIdOperation<ProjectInput, Project>;
        delete: DeleteOperation<{}>;
        deleteById: DeleteOperation<string>;
        lookups(dataOrId: string | { data: ProjectInput }): Project$Lookups;
        getDefaults: GetDefaultsOperation<Project>;
    }
    export interface SaleableProduct extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        budget: Budget;
        task: Task;
        lineNumber: integer;
        product: Product;
        description: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        plannedQuantity: string;
        plannedUnit: UnitOfMeasure;
        quantity: string;
        salesUnit: UnitOfMeasure;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        currency: Currency;
        basePrice: string;
        origin: SaleablePrdLineOrigin;
        initialGrouping: SoldProductsLinePrdGrpLvl;
        productGroupingLevel: SoldProductsLinePrdGrpLvl;
        sourceOperation: Operation;
        sourceProductLine: TaskProduct;
        sourceBudgetLine: BudgetLine;
        lineOrigin: string;
    }
    export interface SaleableProductInput extends ClientNodeInput {
        project?: string;
        budget?: string;
        task?: string;
        lineNumber?: integer | string;
        product?: string;
        description?: string;
        majorVersion?: string;
        minorVersion?: string;
        plannedQuantity?: decimal | string;
        plannedUnit?: string;
        quantity?: decimal | string;
        salesUnit?: string;
        quantityInStockUnit?: decimal | string;
        stockUnit?: string;
        currency?: string;
        basePrice?: decimal | string;
        origin?: SaleablePrdLineOrigin;
        initialGrouping?: SoldProductsLinePrdGrpLvl;
        productGroupingLevel?: SoldProductsLinePrdGrpLvl;
        sourceOperation?: integer | string;
        sourceProductLine?: integer | string;
        sourceBudgetLine?: integer | string;
        lineOrigin?: string;
    }
    export interface SaleableProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        budget: Budget;
        task: Task;
        lineNumber: integer;
        product: Product;
        description: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        plannedQuantity: string;
        plannedUnit: UnitOfMeasure;
        quantity: string;
        salesUnit: UnitOfMeasure;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        currency: Currency;
        basePrice: string;
        origin: SaleablePrdLineOrigin;
        initialGrouping: SoldProductsLinePrdGrpLvl;
        productGroupingLevel: SoldProductsLinePrdGrpLvl;
        sourceOperation: Operation;
        sourceProductLine: TaskProduct;
        sourceBudgetLine: BudgetLine;
        lineOrigin: string;
    }
    export interface SaleableProduct$Lookups {
        project: QueryOperation<ProjectLink>;
        budget: QueryOperation<Budget>;
        task: QueryOperation<Task>;
        product: QueryOperation<Product>;
        majorVersion: QueryOperation<MajorVersionStatus>;
        plannedUnit: QueryOperation<UnitOfMeasure>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
        sourceOperation: QueryOperation<Operation>;
        sourceProductLine: QueryOperation<TaskProduct>;
        sourceBudgetLine: QueryOperation<BudgetLine>;
    }
    export interface SaleableProduct$Operations {
        query: QueryOperation<SaleableProduct>;
        read: ReadOperation<SaleableProduct>;
        aggregate: {
            read: AggregateReadOperation<SaleableProduct>;
            query: AggregateQueryOperation<SaleableProduct>;
        };
        lookups(dataOrId: string | { data: SaleableProductInput }): SaleableProduct$Lookups;
        getDefaults: GetDefaultsOperation<SaleableProduct>;
    }
    export interface TaskCategoryOperation extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        category: TaskCategory;
        lineNumber: integer;
        site: Site;
        numberOfResource1: WorkCenter;
        numberOfResource2: WorkCenter;
        localizedDescription: string;
        packingUnit: UnitOfMeasure;
        plannedLoad: string;
        duration: integer;
        employee: ProjectUser;
        timeCategory: TimeCategory;
    }
    export interface TaskCategoryOperationInput extends ClientNodeInput {
        category?: string;
        lineNumber?: integer | string;
        site?: string;
        numberOfResource1?: string;
        numberOfResource2?: string;
        localizedDescription?: string;
        packingUnit?: string;
        plannedLoad?: decimal | string;
        duration?: integer | string;
        employee?: string;
        timeCategory?: string;
    }
    export interface TaskCategoryOperationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        category: TaskCategory;
        lineNumber: integer;
        site: Site;
        numberOfResource1: WorkCenter;
        numberOfResource2: WorkCenter;
        localizedDescription: string;
        packingUnit: UnitOfMeasure;
        plannedLoad: string;
        duration: integer;
        employee: ProjectUser;
        timeCategory: TimeCategory;
    }
    export interface TaskCategoryOperation$Lookups {
        category: QueryOperation<TaskCategory>;
        site: QueryOperation<Site>;
        numberOfResource1: QueryOperation<WorkCenter>;
        numberOfResource2: QueryOperation<WorkCenter>;
        packingUnit: QueryOperation<UnitOfMeasure>;
        employee: QueryOperation<ProjectUser>;
        timeCategory: QueryOperation<TimeCategory>;
    }
    export interface TaskCategoryOperation$Operations {
        query: QueryOperation<TaskCategoryOperation>;
        read: ReadOperation<TaskCategoryOperation>;
        aggregate: {
            read: AggregateReadOperation<TaskCategoryOperation>;
            query: AggregateQueryOperation<TaskCategoryOperation>;
        };
        lookups(dataOrId: string | { data: TaskCategoryOperationInput }): TaskCategoryOperation$Lookups;
        getDefaults: GetDefaultsOperation<TaskCategoryOperation>;
    }
    export interface TaskCategory extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        type: ProjectTaskType;
        planningMode: PlanningMode;
        duration: integer;
        costType: CostType;
        personResponsible: User;
        timeCategory: TimeCategory;
        lines: ClientCollection<TaskCategoryOperation>;
    }
    export interface TaskCategoryInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isActive?: boolean | string;
        type?: ProjectTaskType;
        planningMode?: PlanningMode;
        duration?: integer | string;
        costType?: string;
        personResponsible?: string;
        timeCategory?: string;
        lines?: Partial<TaskCategoryOperationInput>[];
    }
    export interface TaskCategoryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        type: ProjectTaskType;
        planningMode: PlanningMode;
        duration: integer;
        costType: CostType;
        personResponsible: User;
        timeCategory: TimeCategory;
        lines: ClientCollection<TaskCategoryOperation>;
    }
    export interface TaskCategory$Lookups {
        costType: QueryOperation<CostType>;
        personResponsible: QueryOperation<User>;
        timeCategory: QueryOperation<TimeCategory>;
    }
    export interface TaskCategory$Operations {
        query: QueryOperation<TaskCategory>;
        read: ReadOperation<TaskCategory>;
        aggregate: {
            read: AggregateReadOperation<TaskCategory>;
            query: AggregateQueryOperation<TaskCategory>;
        };
        lookups(dataOrId: string | { data: TaskCategoryInput }): TaskCategory$Lookups;
        getDefaults: GetDefaultsOperation<TaskCategory>;
    }
    export interface TaskPrecedenceLink extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        lineNumber: integer;
        linkedTask: ProjectLink;
        linkType: TasksLinkType;
        constraintType: ConstraintType;
        lagDays: integer;
    }
    export interface TaskPrecedenceLinkInput extends ClientNodeInput {
        project?: string;
        task?: string;
        lineNumber?: integer | string;
        linkedTask?: string;
        linkType?: TasksLinkType;
        constraintType?: ConstraintType;
        lagDays?: integer | string;
    }
    export interface TaskPrecedenceLinkBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        lineNumber: integer;
        linkedTask: ProjectLink;
        linkType: TasksLinkType;
        constraintType: ConstraintType;
        lagDays: integer;
    }
    export interface TaskPrecedenceLink$Lookups {
        project: QueryOperation<Project>;
        task: QueryOperation<Task>;
        linkedTask: QueryOperation<ProjectLink>;
    }
    export interface TaskPrecedenceLink$Operations {
        query: QueryOperation<TaskPrecedenceLink>;
        read: ReadOperation<TaskPrecedenceLink>;
        aggregate: {
            read: AggregateReadOperation<TaskPrecedenceLink>;
            query: AggregateQueryOperation<TaskPrecedenceLink>;
        };
        lookups(dataOrId: string | { data: TaskPrecedenceLinkInput }): TaskPrecedenceLink$Lookups;
        getDefaults: GetDefaultsOperation<TaskPrecedenceLink>;
    }
    export interface TaskProduct extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        lineNumber: integer;
        site: Site;
        shippingSite: Site;
        unit: UnitOfMeasure;
        requiredQuantity: string;
        requirementDate: string;
        product: Product;
        localizedDescription: string;
        majorVersion: MajorVersionStatus;
        minorVersion: ProductVersion;
        bomCode: BomCodes;
        planNumber: string;
        planVersion: string;
        isSold: boolean;
        consumptionMode: ConsumptionMode;
        allocatedQuantity: string;
        shortageQuantity: string;
        manualAllocation: string;
        allocationStatus: AllocationStatus;
        allocationType: AllocationType;
        inProcessQuantity: string;
        deliveredQuantity: string;
        deliveryStatus: DeliveryStatus;
        orderedQuantity: string;
        workInProgressOrderNumber: string;
        closeWip: boolean;
        isDeliverable: boolean;
        primaryBudgetingMethod: BudgetMethod;
        secondaryBudgetingMethod: BudgetMethod;
        manualBudgetAmount: string;
        currency: Currency;
        saleableProductLine: string;
        stockManagement: StockManagement;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface TaskProductInput extends ClientNodeInput {
        project?: string;
        task?: string;
        lineNumber?: integer | string;
        site?: string;
        shippingSite?: string;
        unit?: string;
        requiredQuantity?: decimal | string;
        requirementDate?: string;
        product?: string;
        localizedDescription?: string;
        majorVersion?: string;
        minorVersion?: string;
        bomCode?: integer | string;
        planNumber?: string;
        planVersion?: string;
        isSold?: boolean | string;
        consumptionMode?: ConsumptionMode;
        allocatedQuantity?: decimal | string;
        shortageQuantity?: decimal | string;
        manualAllocation?: decimal | string;
        allocationStatus?: AllocationStatus;
        allocationType?: AllocationType;
        inProcessQuantity?: decimal | string;
        deliveredQuantity?: decimal | string;
        deliveryStatus?: DeliveryStatus;
        orderedQuantity?: decimal | string;
        workInProgressOrderNumber?: string;
        closeWip?: boolean | string;
        isDeliverable?: boolean | string;
        primaryBudgetingMethod?: BudgetMethod;
        secondaryBudgetingMethod?: BudgetMethod;
        manualBudgetAmount?: decimal | string;
        currency?: string;
        saleableProductLine?: string;
        stockManagement?: StockManagement;
        longComment?: TextStream;
        longDescription?: TextStream;
    }
    export interface TaskProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        task: Task;
        lineNumber: integer;
        site: Site;
        shippingSite: Site;
        unit: UnitOfMeasure;
        requiredQuantity: string;
        requirementDate: string;
        product: Product;
        localizedDescription: string;
        majorVersion: MajorVersionStatus;
        minorVersion: ProductVersion;
        bomCode: BomCodes;
        planNumber: string;
        planVersion: string;
        isSold: boolean;
        consumptionMode: ConsumptionMode;
        allocatedQuantity: string;
        shortageQuantity: string;
        manualAllocation: string;
        allocationStatus: AllocationStatus;
        allocationType: AllocationType;
        inProcessQuantity: string;
        deliveredQuantity: string;
        deliveryStatus: DeliveryStatus;
        orderedQuantity: string;
        workInProgressOrderNumber: string;
        closeWip: boolean;
        isDeliverable: boolean;
        primaryBudgetingMethod: BudgetMethod;
        secondaryBudgetingMethod: BudgetMethod;
        manualBudgetAmount: string;
        currency: Currency;
        saleableProductLine: string;
        stockManagement: StockManagement;
        longComment: TextStream;
        longDescription: TextStream;
    }
    export interface TaskProduct$Lookups {
        project: QueryOperation<Project>;
        task: QueryOperation<Task>;
        site: QueryOperation<Site>;
        shippingSite: QueryOperation<Site>;
        unit: QueryOperation<UnitOfMeasure>;
        product: QueryOperation<Product>;
        majorVersion: QueryOperation<MajorVersionStatus>;
        minorVersion: QueryOperation<ProductVersion>;
        bomCode: QueryOperation<BomCodes>;
        currency: QueryOperation<Currency>;
    }
    export interface TaskProduct$Operations {
        query: QueryOperation<TaskProduct>;
        read: ReadOperation<TaskProduct>;
        aggregate: {
            read: AggregateReadOperation<TaskProduct>;
            query: AggregateQueryOperation<TaskProduct>;
        };
        lookups(dataOrId: string | { data: TaskProductInput }): TaskProduct$Lookups;
        getDefaults: GetDefaultsOperation<TaskProduct>;
    }
    export interface Task extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        code: string;
        site: Site;
        parent: Task;
        sortKey: integer;
        taskType: OpeProvTask;
        startDate: string;
        endDate: string;
        duration: integer;
        launchingDate: string;
        planningDate: string;
        beginningDate: string;
        closingDate: string;
        suspensionDate: string;
        isToLaunch: boolean;
        status: ProjectTaskStatus;
        category: TaskCategory;
        budget: Budget;
        responsiblePerson: ProjectUser;
        sequenceNumber: string;
        estimatedProgress: string;
        progressRange: MiscellaneousTable;
        progressDate: string;
        progressMethod: EstimationMethodUsed;
        billingMode: BillingMode;
        dueDate: string;
        timeCategory: TimeCategory;
        source: ProjectLink;
        operations: ClientCollection<Operation>;
        products: ClientCollection<TaskProduct>;
        precedenceLinks: ClientCollection<TaskPrecedenceLink>;
        projectLink: ProjectLink;
        isActive: boolean;
        isBudgetCreatedAutomatically: boolean;
        localizedDescription: string;
        localizedShortDescription: string;
        longComment: TextStream;
        longDescription: TextStream;
        type: ProjectAllocationType;
    }
    export interface TaskInput extends ClientNodeInput {
        project?: string;
        code?: string;
        site?: string;
        parent?: string;
        sortKey?: integer | string;
        taskType?: OpeProvTask;
        startDate?: string;
        endDate?: string;
        duration?: integer | string;
        launchingDate?: string;
        planningDate?: string;
        beginningDate?: string;
        closingDate?: string;
        suspensionDate?: string;
        isToLaunch?: boolean | string;
        status?: ProjectTaskStatus;
        category?: string;
        budget?: string;
        responsiblePerson?: string;
        sequenceNumber?: string;
        estimatedProgress?: decimal | string;
        progressRange?: string;
        progressDate?: string;
        progressMethod?: EstimationMethodUsed;
        billingMode?: BillingMode;
        dueDate?: string;
        timeCategory?: string;
        source?: string;
        operations?: Partial<OperationInput>[];
        products?: Partial<TaskProductInput>[];
        precedenceLinks?: Partial<TaskPrecedenceLinkInput>[];
        projectLink?: string;
        isActive?: boolean | string;
        isBudgetCreatedAutomatically?: boolean | string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        longComment?: TextStream;
        longDescription?: TextStream;
        type?: ProjectAllocationType;
    }
    export interface TaskBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: Project;
        code: string;
        site: Site;
        parent: Task;
        sortKey: integer;
        taskType: OpeProvTask;
        startDate: string;
        endDate: string;
        duration: integer;
        launchingDate: string;
        planningDate: string;
        beginningDate: string;
        closingDate: string;
        suspensionDate: string;
        isToLaunch: boolean;
        status: ProjectTaskStatus;
        category: TaskCategory;
        budget: Budget;
        responsiblePerson: ProjectUser;
        sequenceNumber: string;
        estimatedProgress: string;
        progressRange: MiscellaneousTable;
        progressDate: string;
        progressMethod: EstimationMethodUsed;
        billingMode: BillingMode;
        dueDate: string;
        timeCategory: TimeCategory;
        source: ProjectLink;
        operations: ClientCollection<Operation>;
        products: ClientCollection<TaskProduct>;
        precedenceLinks: ClientCollection<TaskPrecedenceLink>;
        projectLink: ProjectLink;
        isActive: boolean;
        isBudgetCreatedAutomatically: boolean;
        localizedDescription: string;
        localizedShortDescription: string;
        longComment: TextStream;
        longDescription: TextStream;
        type: ProjectAllocationType;
    }
    export interface Task$Lookups {
        project: QueryOperation<Project>;
        site: QueryOperation<Site>;
        parent: QueryOperation<Task>;
        category: QueryOperation<TaskCategory>;
        budget: QueryOperation<Budget>;
        responsiblePerson: QueryOperation<ProjectUser>;
        progressRange: QueryOperation<MiscellaneousTable>;
        timeCategory: QueryOperation<TimeCategory>;
        source: QueryOperation<ProjectLink>;
        projectLink: QueryOperation<ProjectLink>;
    }
    export interface Task$Operations {
        query: QueryOperation<Task>;
        read: ReadOperation<Task>;
        aggregate: {
            read: AggregateReadOperation<Task>;
            query: AggregateQueryOperation<Task>;
        };
        create: CreateOperation<TaskInput, Task>;
        getDuplicate: GetDuplicateOperation<Task>;
        update: UpdateOperation<TaskInput, Task>;
        updateById: UpdateByIdOperation<TaskInput, Task>;
        delete: DeleteOperation<{}>;
        deleteById: DeleteOperation<string>;
        lookups(dataOrId: string | { data: TaskInput }): Task$Lookups;
        getDefaults: GetDefaultsOperation<Task>;
    }
    export interface TimeCategory extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        multiplyingRate: string;
        isNonProjectCategory: boolean;
        costType: CostType;
        rateType: ExchangeRateType;
        isBillable: boolean;
    }
    export interface TimeCategoryInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        multiplyingRate?: decimal | string;
        isNonProjectCategory?: boolean | string;
        costType?: string;
        rateType?: ExchangeRateType;
        isBillable?: boolean | string;
    }
    export interface TimeCategoryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        multiplyingRate: string;
        isNonProjectCategory: boolean;
        costType: CostType;
        rateType: ExchangeRateType;
        isBillable: boolean;
    }
    export interface TimeCategory$Lookups {
        costType: QueryOperation<CostType>;
    }
    export interface TimeCategory$Operations {
        query: QueryOperation<TimeCategory>;
        read: ReadOperation<TimeCategory>;
        aggregate: {
            read: AggregateReadOperation<TimeCategory>;
            query: AggregateQueryOperation<TimeCategory>;
        };
        lookups(dataOrId: string | { data: TimeCategoryInput }): TimeCategory$Lookups;
        getDefaults: GetDefaultsOperation<TimeCategory>;
    }
    export interface TimeEntryLineCurrencyRates extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        employee: string;
        lineNumber: integer;
        chartOfAccounts: ChartOfAccounts;
        account: Account;
        multiplyingRate: string;
        dividingRate: string;
        ledgerType: GeneralLedgerTypes;
        ledgerCurrency: Currency;
    }
    export interface TimeEntryLineCurrencyRatesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        employee?: string;
        lineNumber?: integer | string;
        chartOfAccounts?: string;
        account?: string;
        multiplyingRate?: decimal | string;
        dividingRate?: decimal | string;
        ledgerType?: GeneralLedgerTypes;
        ledgerCurrency?: string;
    }
    export interface TimeEntryLineCurrencyRatesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        employee: string;
        lineNumber: integer;
        chartOfAccounts: ChartOfAccounts;
        account: Account;
        multiplyingRate: string;
        dividingRate: string;
        ledgerType: GeneralLedgerTypes;
        ledgerCurrency: Currency;
    }
    export interface TimeEntryLineCurrencyRates$Lookups {
        chartOfAccounts: QueryOperation<ChartOfAccounts>;
        account: QueryOperation<Account>;
        ledgerCurrency: QueryOperation<Currency>;
    }
    export interface TimeEntryLineCurrencyRates$Operations {
        query: QueryOperation<TimeEntryLineCurrencyRates>;
        read: ReadOperation<TimeEntryLineCurrencyRates>;
        aggregate: {
            read: AggregateReadOperation<TimeEntryLineCurrencyRates>;
            query: AggregateQueryOperation<TimeEntryLineCurrencyRates>;
        };
        lookups(dataOrId: string | { data: TimeEntryLineCurrencyRatesInput }): TimeEntryLineCurrencyRates$Lookups;
        getDefaults: GetDefaultsOperation<TimeEntryLineCurrencyRates>;
    }
    export interface TimeEntryLineDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        employee: string;
        lineNumber: integer;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface TimeEntryLineDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        employee?: string;
        lineNumber?: integer | string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface TimeEntryLineDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        employee: string;
        lineNumber: integer;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface TimeEntryLineDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface TimeEntryLineDimensions$Operations {
        query: QueryOperation<TimeEntryLineDimensions>;
        read: ReadOperation<TimeEntryLineDimensions>;
        aggregate: {
            read: AggregateReadOperation<TimeEntryLineDimensions>;
            query: AggregateQueryOperation<TimeEntryLineDimensions>;
        };
        lookups(dataOrId: string | { data: TimeEntryLineDimensionsInput }): TimeEntryLineDimensions$Lookups;
        getDefaults: GetDefaultsOperation<TimeEntryLineDimensions>;
    }
    export interface TimeEntryLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: ProjectUser;
        lineNumber: integer;
        date: string;
        taskLink: ProjectLink;
        budgetLink: ProjectLink;
        project: Project;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        assignmentLine: OperationAssignment;
        budget: Budget;
        financialSite: Site;
        currency: Currency;
        rateType: ExchangeRateType;
        projectCostType: CostType;
        employeeCostType: CostType;
        projectLaborRate: string;
        employeeLaborRate: string;
        timeSpent: string;
        unit: UnitOfMeasure;
        timeCategory: TimeCategory;
        rateMultiplier: string;
        localizedDescription: string;
        isValidated: boolean;
        status: TimeEntryStatus;
        origin: TimeEntryOrigin;
        validatedBy: User;
        controlledBy: User;
        approvedBy: User;
        entryType: EntryType;
        rejectedBy: User;
        journal: Journal;
        postedBy: User;
        journalNumber: string;
        isBillable: boolean;
        billableFrom: string;
        billedQuantity: string;
        longComment: TextStream;
        longDescription: TextStream;
        connectedEmployee: ProjectUser;
        defaultTimeCategory: TimeCategory;
        defaultUnit: UnitOfMeasure;
        isNegativeTimeSpentAllowed: boolean;
        isTimeEntryAdministrator: boolean;
        isTimeEntryEmployee: boolean;
        isValidatedDefault: boolean;
        currencyRates: ClientCollection<TimeEntryLineCurrencyRates>;
        dimensions: ClientCollection<TimeEntryLineDimensions>;
    }
    export interface TimeEntryLineInput extends ClientNodeInput {
        employee?: string;
        lineNumber?: integer | string;
        date?: string;
        taskLink?: string;
        budgetLink?: string;
        project?: string;
        task?: string;
        operation?: integer | string;
        firstOperationSplit?: integer | string;
        assignmentLine?: integer | string;
        budget?: string;
        financialSite?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        projectCostType?: string;
        employeeCostType?: string;
        projectLaborRate?: decimal | string;
        employeeLaborRate?: decimal | string;
        timeSpent?: decimal | string;
        unit?: string;
        timeCategory?: string;
        rateMultiplier?: decimal | string;
        localizedDescription?: string;
        isValidated?: boolean | string;
        status?: TimeEntryStatus;
        origin?: TimeEntryOrigin;
        validatedBy?: string;
        controlledBy?: string;
        approvedBy?: string;
        entryType?: string;
        rejectedBy?: string;
        journal?: string;
        postedBy?: string;
        journalNumber?: string;
        isBillable?: boolean | string;
        billableFrom?: string;
        billedQuantity?: decimal | string;
        longComment?: TextStream;
        longDescription?: TextStream;
        currencyRates?: Partial<TimeEntryLineCurrencyRatesInput>[];
        dimensions?: Partial<TimeEntryLineDimensionsInput>[];
    }
    export interface TimeEntryLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: ProjectUser;
        lineNumber: integer;
        date: string;
        taskLink: ProjectLink;
        budgetLink: ProjectLink;
        project: Project;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        assignmentLine: OperationAssignment;
        budget: Budget;
        financialSite: Site;
        currency: Currency;
        rateType: ExchangeRateType;
        projectCostType: CostType;
        employeeCostType: CostType;
        projectLaborRate: string;
        employeeLaborRate: string;
        timeSpent: string;
        unit: UnitOfMeasure;
        timeCategory: TimeCategory;
        rateMultiplier: string;
        localizedDescription: string;
        isValidated: boolean;
        status: TimeEntryStatus;
        origin: TimeEntryOrigin;
        validatedBy: User;
        controlledBy: User;
        approvedBy: User;
        entryType: EntryType;
        rejectedBy: User;
        journal: Journal;
        postedBy: User;
        journalNumber: string;
        isBillable: boolean;
        billableFrom: string;
        billedQuantity: string;
        longComment: TextStream;
        longDescription: TextStream;
        connectedEmployee: ProjectUser;
        defaultTimeCategory: TimeCategory;
        defaultUnit: UnitOfMeasure;
        isNegativeTimeSpentAllowed: boolean;
        isTimeEntryAdministrator: boolean;
        isTimeEntryEmployee: boolean;
        isValidatedDefault: boolean;
        currencyRates: ClientCollection<TimeEntryLineCurrencyRatesBinding>;
        dimensions: ClientCollection<TimeEntryLineDimensionsBinding>;
    }
    export interface TimeEntryLine$Mutations {
        computeProjectEmployeeCostType: Node$Operation<
            {
                parameters?: {
                    project: string;
                    task: string;
                    operation: integer | string;
                    employee: string;
                    timeCategory: string;
                };
            },
            {
                employeeCostType: string;
                projectCostType: string;
            }
        >;
        computeProjectEmployeeLaborRate: Node$Operation<
            {
                parameters?: {
                    employee: string;
                    date: string;
                    unit: string;
                    currency: string;
                    rateType: ExchangeRateType;
                    projectCostType: string;
                    employeeCostType: string;
                };
            },
            {
                projectLaborRate: string;
                employeeLaborRate: string;
                message: string;
            }
        >;
        computeUnitOfMeasure: Node$Operation<
            {
                parameters?: {
                    project: string;
                    task: string;
                    operation: integer | string;
                    employee: string;
                    timeCategory: string;
                    costType: string;
                };
            },
            {
                unit: string;
            }
        >;
    }
    export interface TimeEntryLine$Lookups {
        employee: QueryOperation<ProjectUser>;
        taskLink: QueryOperation<ProjectLink>;
        budgetLink: QueryOperation<ProjectLink>;
        project: QueryOperation<Project>;
        task: QueryOperation<Task>;
        operation: QueryOperation<Operation>;
        assignmentLine: QueryOperation<OperationAssignment>;
        budget: QueryOperation<Budget>;
        financialSite: QueryOperation<Site>;
        currency: QueryOperation<Currency>;
        projectCostType: QueryOperation<CostType>;
        employeeCostType: QueryOperation<CostType>;
        unit: QueryOperation<UnitOfMeasure>;
        timeCategory: QueryOperation<TimeCategory>;
        validatedBy: QueryOperation<User>;
        controlledBy: QueryOperation<User>;
        approvedBy: QueryOperation<User>;
        entryType: QueryOperation<EntryType>;
        rejectedBy: QueryOperation<User>;
        journal: QueryOperation<Journal>;
        postedBy: QueryOperation<User>;
        connectedEmployee: QueryOperation<ProjectUser>;
        defaultTimeCategory: QueryOperation<TimeCategory>;
        defaultUnit: QueryOperation<UnitOfMeasure>;
    }
    export interface TimeEntryLine$Operations {
        query: QueryOperation<TimeEntryLine>;
        read: ReadOperation<TimeEntryLine>;
        aggregate: {
            read: AggregateReadOperation<TimeEntryLine>;
            query: AggregateQueryOperation<TimeEntryLine>;
        };
        create: CreateOperation<TimeEntryLineInput, TimeEntryLine>;
        getDuplicate: GetDuplicateOperation<TimeEntryLine>;
        update: UpdateOperation<TimeEntryLineInput, TimeEntryLine>;
        updateById: UpdateByIdOperation<TimeEntryLineInput, TimeEntryLine>;
        delete: DeleteOperation<{}>;
        deleteById: DeleteOperation<string>;
        mutations: TimeEntryLine$Mutations;
        lookups(dataOrId: string | { data: TimeEntryLineInput }): TimeEntryLine$Lookups;
        getDefaults: GetDefaultsOperation<TimeEntryLine>;
    }
    export interface CostTypeExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        site: Site;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        dimensions: ClientCollection<CostTypeDimensions>;
        costTypeGroup: MiscellaneousTable;
        isPurchasingCost: boolean;
        isLaborCost: boolean;
        isStockIssueCost: boolean;
        isAccountingCost: boolean;
        product: Product;
        isIndirectCost: boolean;
        indirectCostPercentage: string;
        indirectCostType: CostType;
        laborUnit: UnitOfMeasure;
        currency: Currency;
        chart: ChartOfAccounts;
        account: Account;
        accountingCode: AccountingCode;
        rateDates: ClientCollection<CostDate>;
        costGroupLinks: ClientCollection<CostGroupLink>;
    }
    export interface CostTypeInputExtension {
        code?: string;
        site?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isActive?: boolean | string;
        dimensions?: Partial<CostTypeDimensionsInput>[];
        costTypeGroup?: string;
        isPurchasingCost?: boolean | string;
        isLaborCost?: boolean | string;
        isStockIssueCost?: boolean | string;
        isAccountingCost?: boolean | string;
        product?: string;
        isIndirectCost?: boolean | string;
        indirectCostPercentage?: decimal | string;
        indirectCostType?: string;
        laborUnit?: string;
        currency?: string;
        chart?: string;
        account?: string;
        accountingCode?: string;
        rateDates?: Partial<CostDateInput>[];
        costGroupLinks?: Partial<CostGroupLinkInput>[];
    }
    export interface CostTypeBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        site: Site;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        dimensions: ClientCollection<CostTypeDimensionsBinding>;
        costTypeGroup: MiscellaneousTable;
        isPurchasingCost: boolean;
        isLaborCost: boolean;
        isStockIssueCost: boolean;
        isAccountingCost: boolean;
        product: Product;
        isIndirectCost: boolean;
        indirectCostPercentage: string;
        indirectCostType: CostType;
        laborUnit: UnitOfMeasure;
        currency: Currency;
        chart: ChartOfAccounts;
        account: Account;
        accountingCode: AccountingCode;
        rateDates: ClientCollection<CostDate>;
        costGroupLinks: ClientCollection<CostGroupLink>;
    }
    export interface CostTypeExtension$Lookups {
        costTypeGroup: QueryOperation<MiscellaneousTable>;
        product: QueryOperation<Product>;
        indirectCostType: QueryOperation<CostType>;
        laborUnit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
        chart: QueryOperation<ChartOfAccounts>;
        account: QueryOperation<Account>;
        accountingCode: QueryOperation<AccountingCode>;
    }
    export interface CostTypeExtension$Operations {
        lookups(dataOrId: string | { data: CostTypeInput }): CostTypeExtension$Lookups;
    }
    export interface ProjectLinkExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        localizedShortDescription: string;
        site: Site;
        type: ProjectAllocationType;
        isActive: boolean;
        company: Company;
        project: Project;
        budget: Budget;
        task: Task;
        financialSite: Site;
        projectStatus: ProjectStatus;
        budgetStatus: ProjectBudgetStatus;
        taskStatus: ProjectTaskStatus;
        billingMode: BillingMode;
    }
    export interface ProjectLinkInputExtension {
        id?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        site?: string;
        type?: ProjectAllocationType;
        isActive?: boolean | string;
        company?: string;
        project?: string;
        budget?: string;
        task?: string;
        financialSite?: string;
        projectStatus?: ProjectStatus;
        budgetStatus?: ProjectBudgetStatus;
        taskStatus?: ProjectTaskStatus;
        billingMode?: BillingMode;
    }
    export interface ProjectLinkBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        localizedShortDescription: string;
        site: Site;
        type: ProjectAllocationType;
        isActive: boolean;
        company: Company;
        project: Project;
        budget: Budget;
        task: Task;
        financialSite: Site;
        projectStatus: ProjectStatus;
        budgetStatus: ProjectBudgetStatus;
        taskStatus: ProjectTaskStatus;
        billingMode: BillingMode;
    }
    export interface ProjectLinkExtension$Lookups {
        project: QueryOperation<Project>;
        budget: QueryOperation<Budget>;
        task: QueryOperation<Task>;
        financialSite: QueryOperation<Site>;
    }
    export interface ProjectLinkExtension$Operations {
        lookups(dataOrId: string | { data: ProjectLinkInput }): ProjectLinkExtension$Lookups;
    }
    export interface WorkCenterExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        manufacturingSite: Site;
        workCenterGroup: WorkCenterGroup;
        costingDimension: string;
        weeklyStructure: WeeklyStructure;
        efficiencyInPercentage: string;
        shrinkageInPercentage: string;
        numberOfResources: integer;
        automaticClosingPercentage: string;
        qualificationLevel: string;
        totalExpectedTimeInHours: string;
        totalTimeCompleteInHours: string;
        isConstraint: boolean;
        isRccp: boolean;
        isRunDuringEmployeeBreak: boolean;
        description: string;
        costTypeProject: CostType;
    }
    export interface WorkCenterInputExtension {
        code?: string;
        manufacturingSite?: string;
        workCenterGroup?: string;
        costingDimension?: string;
        weeklyStructure?: string;
        efficiencyInPercentage?: decimal | string;
        shrinkageInPercentage?: decimal | string;
        numberOfResources?: integer | string;
        automaticClosingPercentage?: decimal | string;
        qualificationLevel?: string;
        totalExpectedTimeInHours?: decimal | string;
        totalTimeCompleteInHours?: decimal | string;
        isConstraint?: boolean | string;
        isRccp?: boolean | string;
        isRunDuringEmployeeBreak?: boolean | string;
        description?: string;
        costTypeProject?: string;
    }
    export interface WorkCenterBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        manufacturingSite: Site;
        workCenterGroup: WorkCenterGroup;
        costingDimension: string;
        weeklyStructure: WeeklyStructure;
        efficiencyInPercentage: string;
        shrinkageInPercentage: string;
        numberOfResources: integer;
        automaticClosingPercentage: string;
        qualificationLevel: string;
        totalExpectedTimeInHours: string;
        totalTimeCompleteInHours: string;
        isConstraint: boolean;
        isRccp: boolean;
        isRunDuringEmployeeBreak: boolean;
        description: string;
        costTypeProject: CostType;
    }
    export interface WorkCenterExtension$Lookups {
        costTypeProject: QueryOperation<CostType>;
    }
    export interface WorkCenterExtension$Operations {
        lookups(dataOrId: string | { data: WorkCenterInput }): WorkCenterExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-project-management/BudgetLine': BudgetLine$Operations;
        '@sage/x3-project-management/Budget': Budget$Operations;
        '@sage/x3-project-management/CostDate': CostDate$Operations;
        '@sage/x3-project-management/CostGroupLink': CostGroupLink$Operations;
        '@sage/x3-project-management/CostStructureReportingSnapshot': CostStructureReportingSnapshot$Operations;
        '@sage/x3-project-management/CostTypeReportingSnapshot': CostTypeReportingSnapshot$Operations;
        '@sage/x3-project-management/FinancialOverviewStructure': FinancialOverviewStructure$Operations;
        '@sage/x3-project-management/OperationAssignment': OperationAssignment$Operations;
        '@sage/x3-project-management/OperationPrecedenceLink': OperationPrecedenceLink$Operations;
        '@sage/x3-project-management/Operation': Operation$Operations;
        '@sage/x3-project-management/PjmProjectDimensions': PjmProjectDimensions$Operations;
        '@sage/x3-project-management/ProjectAssignment': ProjectAssignment$Operations;
        '@sage/x3-project-management/ProjectUserCapacityVariation': ProjectUserCapacityVariation$Operations;
        '@sage/x3-project-management/ProjectUser': ProjectUser$Operations;
        '@sage/x3-project-management/Project': Project$Operations;
        '@sage/x3-project-management/SaleableProduct': SaleableProduct$Operations;
        '@sage/x3-project-management/TaskCategoryOperation': TaskCategoryOperation$Operations;
        '@sage/x3-project-management/TaskCategory': TaskCategory$Operations;
        '@sage/x3-project-management/TaskPrecedenceLink': TaskPrecedenceLink$Operations;
        '@sage/x3-project-management/TaskProduct': TaskProduct$Operations;
        '@sage/x3-project-management/Task': Task$Operations;
        '@sage/x3-project-management/TimeCategory': TimeCategory$Operations;
        '@sage/x3-project-management/TimeEntryLineCurrencyRates': TimeEntryLineCurrencyRates$Operations;
        '@sage/x3-project-management/TimeEntryLineDimensions': TimeEntryLineDimensions$Operations;
        '@sage/x3-project-management/TimeEntryLine': TimeEntryLine$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3ProjectManagementData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-project-management-api' {
    export type * from '@sage/x3-project-management-api-partial';
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type {
        CostTypeBindingExtension,
        CostTypeExtension,
        CostTypeExtension$Lookups,
        CostTypeExtension$Operations,
        CostTypeInputExtension,
        ProjectLinkBindingExtension,
        ProjectLinkExtension,
        ProjectLinkExtension$Lookups,
        ProjectLinkExtension$Operations,
        ProjectLinkInputExtension,
    } from '@sage/x3-project-management-api';
    export interface CostType extends CostTypeExtension {}
    export interface CostTypeBinding extends CostTypeBindingExtension {}
    export interface CostTypeInput extends CostTypeInputExtension {}
    export interface CostType$Lookups extends CostTypeExtension$Lookups {}
    export interface CostType$Operations extends CostTypeExtension$Operations {}
    export interface ProjectLink extends ProjectLinkExtension {}
    export interface ProjectLinkBinding extends ProjectLinkBindingExtension {}
    export interface ProjectLinkInput extends ProjectLinkInputExtension {}
    export interface ProjectLink$Lookups extends ProjectLinkExtension$Lookups {}
    export interface ProjectLink$Operations extends ProjectLinkExtension$Operations {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type {
        WorkCenterBindingExtension,
        WorkCenterExtension,
        WorkCenterExtension$Lookups,
        WorkCenterExtension$Operations,
        WorkCenterInputExtension,
    } from '@sage/x3-project-management-api';
    export interface WorkCenter extends WorkCenterExtension {}
    export interface WorkCenterBinding extends WorkCenterBindingExtension {}
    export interface WorkCenterInput extends WorkCenterInputExtension {}
    export interface WorkCenter$Lookups extends WorkCenterExtension$Lookups {}
    export interface WorkCenter$Operations extends WorkCenterExtension$Operations {}
}
