import { DynamoDB } from "@aws-sdk/client-dynamodb";
import { AwsConfigOverride } from "./wrapper/dynamoDbWrapper";
import { LoggerInterface } from "./loggerInterface";
export declare function setUnitTestMode(mock: DynamoDB): void;
export type InvalidatedTokenConfiguration = {
    cluster: string;
    frequencyInSec: number;
    tableName: string;
    awsConfig?: AwsConfigOverride;
    logger?: LoggerInterface;
};
export default class InvalidatedToken {
    private static _instance;
    private _invalidatedTokenList;
    private _interval?;
    private _cluster;
    private _db?;
    private _tableName;
    private _logger?;
    private constructor();
    static get Instance(): InvalidatedToken;
    startListening(config: InvalidatedTokenConfiguration): void;
    stopListening(): void;
    private fetchInvalidatedToken;
    isJTIValid(jti: string): boolean;
}
