/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Walker=void 0;const lodash_1=require("lodash"),conversion_error_1=require("./conversion-error"),logger_1=require("./logger");class VariableScope{constructor(e=null){this.parent=e,this.variables=e?{...e.variables}:{}}set(e,s){this.variables[e]=s}peekVariable(e){return this.variables[e]}resolve(e){const s=this.variables[e];if(void 0===s)throw new conversion_error_1.ConversionError(void 0,`'${e}': variable not found`);return s}push(){return new VariableScope(this)}pop(){if(!this.parent)throw new conversion_error_1.ConversionError(void 0,"cannot pop root scope");return this.parent}}class Walker{constructor(e,s,t,a){this.context=e,this.rootFactory=s,this.resolver=t,this.options=a,this.aliasIndex=0,this.pathSequence=0,this.allTableNames=[];const i={alias:"t0",tableName:t.resolveTableName(s)};this.#e={subQueryDepth:0,aliases:[],scopeAlias:i,results:new Map,variableScope:new VariableScope},this.pushAlias(i),this.thisResults=[{factory:this.rootFactory,type:"reference",sql:"t0._id",path:"this",alias:"t0"}],this.joins=[this.convertThisExpression()]}#e;get scopeAlias(){return this.#e.scopeAlias}set scopeAlias(e){this.#e.scopeAlias=e}get results(){return this.#e.results}get aliases(){return this.#e.aliases}get variableScope(){return this.#e.variableScope}get maxSubQueryDepth(){return this.options.maxSubQueryDepth??Walker.defaultMaxSubQueryDepth}pushVariableScope(){this.#e.variableScope=this.#e.variableScope.push()}popVariableScope(){this.#e.variableScope=this.#e.variableScope.pop()}getUniquePath(e){return this.pathSequence+=1,`${e}.__${this.pathSequence}__`}pushAlias(e){if((0,logger_1.getLogger)().debug(()=>`push alias: ${e.alias}, table: ${e.tableName}, condition: ${e.join?.condition}`),this.aliases.some(s=>s.alias===e.alias))return;if(this.aliases.push(e),!this.allTableNames.includes(e.tableName))this.allTableNames.push(e.tableName)}static createJoin(e,s,t){if(t.withTenantId)e.sqls.push(`${e.alias}._tenant_id`),s.sqls.push(`${s.alias}._tenant_id`);const a=Walker.and(e.sqls.map((e,t)=>`${e}=${s.sqls[t]}`));return{left:e,right:s,condition:a,isNullable:t.isNullable}}createCollectionJoin(e,s){const t=e.parent;if(e.skipJoin)return void(this.scopeAlias={tableName:this.resolver.resolveTableName(e.factory),alias:e.alias});if(!t)throw new conversion_error_1.ConversionError(void 0,`${e.path}: cannot create collection join: no parent`);e.join=Walker.createJoin({alias:t.alias,sqls:s?[`${t.alias}._id`]:[e.sql]},{alias:s?s.alias||"":e.alias||"",sqls:s?[s.sql]:[`${e.alias}._id`]},{withTenantId:!e.factory?.isSharedByAllTenants,isNullable:!!e.property?.isNullable}),this.scopeAlias={tableName:this.resolver.resolveTableName(e.factory),alias:e.alias,join:e.join}}createReferenceJoin(e,s){const t=e.parent;if(!t)throw new conversion_error_1.ConversionError(void 0,`${e.path}: cannot create reference join: no parent`);e.join=Walker.createJoin({alias:t.alias,sqls:s?[`${t.alias}._id`]:[e.sql]},{alias:s?s.alias||"":e.alias||"",sqls:s?[s.sql]:[`${e.alias}._id`]},{withTenantId:!e.factory?.isSharedByAllTenants,isNullable:!!e.property?.isNullable||!!t.join?.isNullable})}makeAliasAndJoin(e){if(!e.parent)throw new Error("cannot create walk aliases: no parent");const s=e.path;if(!s)throw new Error("cannot create walk aliases: no path");if(this.results.get(s))return;const t=e.property?.type;if(!t||"reference"===t||"referenceArray"===t||"collection"===t)this.aliasIndex+=1,e.alias=`t${this.aliasIndex}`,this.results.set(s,e);const a=e.reverseReferenceName?this.walk(e,e.reverseReferenceName):null;if(!t||"reference"===t)this.createReferenceJoin(e,a),this.pushAlias({tableName:this.resolver.resolveTableName(e.factory),alias:e.alias,join:e.join});else if("collection"===t)this.createCollectionJoin(e,a),this.pushAlias(this.scopeAlias);else if("referenceArray"===t)this.scopeAlias={tableName:this.resolver.resolveTableName(e.factory),alias:e.alias},this.pushAlias(this.scopeAlias)}_walk(e,s,t){const a=`${e.path}.${s}`,i=this.results.get(a);if(i)return i;if((0,logger_1.getLogger)().debug(()=>`walk: ${a} from alias=${e.alias}, factory=${e.factory?.name}`),"_id"===s&&"this"!==e.path&&"referenceArray"!==e.property?.type&&"collection"!==e.property?.type&&e.property?.isStored)return{...e,path:`${e.path}._id`};if(e.parent&&!this.results.get(e.path))this.makeAliasAndJoin(e);if("_empty"===s)return e;const r=this.resolver.resolveColumnName(this.context,e,s);if(e.isNullable)r.isNullable=true;if((0,logger_1.getLogger)().debug(()=>`resolved: path=${a}, targetFactory=${r.factory.name} sql=${r.sql}`),r.isInherited&&!r.reverseReferenceName)return this.walk(this.walkToSuper(e),s,t||{factory:r.factory});if("json"===(r.type&&r.property?.type))return{...r,path:a};if("dateRange"===e.type&&"date"===r.type)return r;if("datetimeRange"===e.type&&"datetime"===r.type)return r;if("integerRange"===e.type&&"integer"===r.type)return r;if("decimalRange"===e.type&&"decimal"===r.type)return r;if("integerArray"===e.type&&"integer"===r.type)return r;if("enumArray"===e.type&&"integer"===r.type)return r;if("stringArray"===e.type&&"string"===r.type)return r;return{...r,...t,parent:e,path:a}}walk(e,s,t){return this._walk(e,s,t)}static formatJoins(e,s,t=s){const a=t.filter(s=>s.join?.left.alias===e||s.join?.right.alias===e);if(0===a.length)return"";const i=(0,lodash_1.difference)(t,a);return a.map(t=>{const a=t.join?.left.alias===e?t.join?.right.alias:t.join?.left.alias;let r=a?Walker.formatJoins(a,s,i).trim()||"":"";r=r?` ${r}`:"";const o=s.find(e=>e.alias===a)?.tableName,l=t.join?.isNullable?"LEFT":"INNER",n=`${t.join?.condition}${r}`;if(t.join?.lateral)return`${l} JOIN LATERAL ${t.join.lateral} AS ${a} ON ${n}`;return`${l} JOIN ${o} AS ${a} ON ${n}`}).filter(e=>!!e.trim()).join(" ")}getTableAliases(){const e=this.scopeAlias,s=this.#e.parentScope?this.#e.aliases.slice(this.#e.parentScope.aliases.length).filter(s=>s!==e):this.aliases;return`${e.tableName} AS ${e.alias} ${Walker.formatJoins(e.alias,s)}`}withSubQueryScope(e,s){(0,logger_1.getLogger)().debug(()=>"+++ push scope");const t=this.#e,a=this.maxSubQueryDepth;if(t.subQueryDepth===a)throw new conversion_error_1.ConversionError(void 0,`max sub query depth (${a}) exceeded`);this.#e={parentScope:t,subQueryDepth:t.subQueryDepth+1,results:new Map(t.results),aliases:[...t.aliases],scopeAlias:t.scopeAlias,variableScope:new VariableScope(t.variableScope)};const i=e();if(!this.#e.parentScope)throw new conversion_error_1.ConversionError(void 0,"cannot pop scope: no parent scope");const r=this.getTableAliases(),o=s?s():this.scopeAlias.join?.condition||"",l=this.scopeAlias;return this.#e=this.#e.parentScope,(0,logger_1.getLogger)().debug(()=>`--- pop scope: joinCondition=${o} bodyResult=${i}`),{aliases:r,...i,joinCondition:o,innerAlias:l}}pushAliasAndJoin(e,s){this.joins.push(e),this.pushAlias({tableName:this.resolver.resolveTableName(e.factory),alias:e.alias,join:s})}walkToSuper(e){const s=`${e.path}._super`;let t=this.results.get(s);if(t)return t;(0,logger_1.getLogger)().debug(()=>`walk to super: ${s} from alias=${e.alias}, factory=${e.factory.name}`);const a=e.factory,i=a.baseFactory;if(!i)throw new conversion_error_1.ConversionError(void 0,`${e.path}: no super factory`);this.aliasIndex+=1;const r=`t${this.aliasIndex}`,o=Walker.createJoin({alias:e.alias,sqls:[`${e.alias}._id`]},{alias:r,sqls:[`${r}._id`]},{withTenantId:!a?.isSharedByAllTenants,isNullable:!!(e.isNullable||e.join?.isNullable)});return t={parent:e.parent,path:s,factory:i,alias:r,type:"reference",sql:`${e.alias}._id`,join:o},this.results.set(s,t),this.pushAliasAndJoin(t,o),t}convertThisExpression(e=false){const s=this.thisResults[this.thisResults.length-1];if(this.thisResults.length>1&&"reference"===s.property?.type&&!this.joins.find(e=>e.alias===s.alias)){if(!s.join)throw new conversion_error_1.ConversionError(void 0,`${s.path}: this result has no join`);this.pushAliasAndJoin(s,s.join)}return e?{...s,sql:s.alias}:s}withThisResultScope(e,s){if(e.parent&&!this.results.get(e.path))this.makeAliasAndJoin(e);this.thisResults.push(e);try{return s()}finally{this.thisResults.pop()}}static join(e,s,t){const a=e.filter(e=>!!e);if(a.length>1)return`${a.join(s)}`;return a[0]??t}static and(e){return Walker.join(e," AND ","1=1")}static or(e){return`(${Walker.join(e," OR ","1=2")})`}static{this.defaultMaxSubQueryDepth=3}}exports.Walker=Walker;
//# sourceMappingURL=walker.js.map