import { Resolver } from './resolver';
import { Alias, BasicConversionResult, ConverterFactory, ConverterOptions, ConverterProperty, GenericConversionResult, Join, JoinComponent } from './types';
interface JoinOptions {
    withTenantId: boolean;
    isNullable: boolean;
}
declare class VariableScope {
    private readonly parent;
    private readonly variables;
    constructor(parent?: VariableScope | null);
    set(name: string, value: BasicConversionResult): void;
    peekVariable(name: string): BasicConversionResult | undefined;
    resolve(name: string): BasicConversionResult;
    push(): VariableScope;
    pop(): VariableScope;
}
export declare class Walker<ContextT, FactoryT extends ConverterFactory, PropertyT extends ConverterProperty> {
    #private;
    protected context: ContextT;
    protected rootFactory: FactoryT;
    protected resolver: Resolver<ContextT, FactoryT, PropertyT>;
    readonly options: ConverterOptions;
    constructor(context: ContextT, rootFactory: FactoryT, resolver: Resolver<ContextT, FactoryT, PropertyT>, options: ConverterOptions);
    protected get scopeAlias(): Alias;
    protected set scopeAlias(alias: Alias);
    get results(): Map<string, GenericConversionResult>;
    get aliases(): Alias[];
    get variableScope(): VariableScope;
    get maxSubQueryDepth(): number;
    pushVariableScope(): void;
    popVariableScope(): void;
    aliasIndex: number;
    /** Sequence number for unique paths */
    pathSequence: number;
    readonly allTableNames: string[];
    private readonly joins;
    private readonly thisResults;
    /**
     * Generates a unique path.
     * @param parentPath - The parent path to generate the unique path from (for debugging purposes).
     * @returns The unique path.
     */
    getUniquePath(parentPath: string): string;
    pushAlias(alias: Alias): void;
    protected static createJoin(left: JoinComponent, right: JoinComponent, options: JoinOptions): Join;
    protected createCollectionJoin(resolved: GenericConversionResult, reverseResolved: GenericConversionResult | null): void;
    protected createReferenceJoin(resolved: GenericConversionResult<FactoryT, PropertyT>, reverseResolved: GenericConversionResult<FactoryT, PropertyT> | null): void;
    makeAliasAndJoin(resolved: GenericConversionResult): void;
    private _walk;
    protected walk(parent: GenericConversionResult, name: string, overrides?: {
        factory: FactoryT;
    }): GenericConversionResult<FactoryT, PropertyT>;
    private static formatJoins;
    getTableAliases(): string;
    withSubQueryScope<T extends {}>(body: () => T, getJoinCondition?: () => string): T & {
        aliases: string;
        joinCondition: string;
        innerAlias: Alias;
    };
    private pushAliasAndJoin;
    private walkToSuper;
    convertThisExpression(isMemberOf?: boolean): GenericConversionResult<FactoryT, PropertyT>;
    withThisResultScope<T>(result: GenericConversionResult<FactoryT, PropertyT>, body: () => T): T;
    private static join;
    static and(clauses: (string | undefined)[]): string;
    static or(clauses: (string | undefined)[]): string;
    /**
     * Default maximum depth of sub queries.
     *
     * Default value of 2 will limit us to 1 main query with 2 nested sub queries, for example a query on document
     * with a filter like `document.every(line => line.stockDetails.some(stock => ...))`
     *
     * This is sufficient for our current `getValue` rules but it may limit filters in GraphQL API queries.
     * We could increase it we get requests for it but we should be careful as it could lead to performance issues.
     * And better start with a low value and increase it if needed, after assessing the impact.
     */
    private static readonly defaultMaxSubQueryDepth;
}
export {};
//# sourceMappingURL=walker.d.ts.map