/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TypeConverter=void 0;const conversion_error_1=require("./conversion-error");class TypeConverter{constructor(e){this.dialect=e,this.castOracleDate=(e,r)=>{if(!r||e.property?.type===r)return e;const t=`TO_DATE(${e.sql}, 'YYYY-MM-DD')`;return{...e,type:r,sql:t}}}oracleType(e){switch(e){case"short":return"SMALLINT";case"integer":return"INTEGER";case"decimal":return"DECIMAL";case"float":return"FLOAT";case"double":return"DOUBLE PRECISION";case"date":return"DATE";case"string":return"VARCHAR";case"boolean":return"BOOLEAN";default:throw new conversion_error_1.ConversionError(void 0,`unsupported type: ${e} for ${this.dialect}`)}}sqlServerType(e){switch(e){case"short":return"SMALLINT";case"integer":return"INTEGER";case"decimal":return"DECIMAL";case"float":return"REAL";case"double":return"FLOAT";case"date":return"DATE";case"string":return"VARCHAR";case"boolean":return"BOOLEAN";default:throw new conversion_error_1.ConversionError(void 0,`unsupported type: ${e} for ${this.dialect}`)}}postgresType(e){switch(e){case"short":return"INT4";case"integer":return"INT8";case"decimal":return"NUMERIC";case"float":return"FLOAT4";case"double":return"FLOAT8";case"date":return"DATE";case"string":return"TEXT";case"boolean":return"BOOLEAN";default:throw new conversion_error_1.ConversionError(void 0,`unsupported type: ${e} for this ${this.dialect}`)}}sqlType(e){switch(this.dialect){case"oracle":return this.oracleType(e);case"sqlServer":return this.sqlServerType(e);case"postgres":return this.postgresType(e);default:throw new conversion_error_1.ConversionError(void 0,`unsupported dialect: ${this.dialect}`)}}isNumericType(e){return["short","integer","decimal","float","double"].includes(e)}}exports.TypeConverter=TypeConverter;
//# sourceMappingURL=type-converter.js.map