import { Dict } from '@sage/xtrem-shared';
import * as estree from 'estree';
import { Converter } from './converter';
import { BasicConversionResult, GenericConversionResult } from './types';
export interface RegistryEntry {
    fullName: string;
}
export interface FunctionEntry extends RegistryEntry {
}
export interface ConvertibleFunctionEntry extends FunctionEntry {
    fn: Function;
    parameterNames: string[];
    parsedFunction?: estree.ArrowFunctionExpression | estree.FunctionExpression;
}
export interface BuiltInFunctionEntry extends FunctionEntry {
    convertExpression: (converter: Converter, expression: estree.CallExpression, args: estree.BaseExpression[], fullName: string) => BasicConversionResult;
}
export interface MethodEntry extends RegistryEntry {
    convertExpression: (converter: Converter, result: GenericConversionResult, args: estree.BaseExpression[], fullName: string) => BasicConversionResult;
}
export interface PropertyEntry extends RegistryEntry {
    convertExpression: (converter: Converter, result: GenericConversionResult, fullName: string) => BasicConversionResult;
}
declare class Registry {
    private readonly functionEntries;
    private readonly methodEntries;
    private readonly propertyEntries;
    memberFullName(type: string, memberName: string): string;
    registerConvertibleFunction(entry: ConvertibleFunctionEntry): void;
    registerBuiltInFunctions(entries: Dict<BuiltInFunctionEntry['convertExpression']>): void;
    registerMethods(type: string, entries: Dict<MethodEntry['convertExpression']>): void;
    registerProperties(type: string, entries: Dict<PropertyEntry['convertExpression']>): void;
    private getEntry;
    getFunctionEntry(fullName: string): FunctionEntry;
    getMethodEntry(type: string, methodName: string): MethodEntry;
    getPropertyEntry(type: string, propertyName: string): PropertyEntry;
    registerEsLintMembers(): void;
}
export declare const registry: Registry;
/**
 * Registers a funct function to the TS to SQL converter.
 *
 * @param fullName - The full name of the SQL function.
 * @param fn - The function to be registered.
 * @returns The registered function.
 */
export declare function registerSqlFunction(fullName: string, fn: Function): void;
export {};
//# sourceMappingURL=registry.d.ts.map