import * as estree from 'estree';
import { Converter } from '../converter';
import { BasicConversionResult } from '../types';
/**
 * Converts regular expression method calls to SQL.
 */
export declare class RegExpConverter {
    private readonly converter;
    constructor(converter: Converter);
    /**
     * Converts a RegExp method call to SQL.
     *
     * @param expression - The method call expression node.
     * @param regexp - The regular expression to be used for conversion.
     * @param methodName - The name of the method being called.
     * @param args - The arguments passed to the method call.
     * @returns The result of the conversion.
     */
    convertMethodCall(expression: estree.Node, regexp: RegExp, methodName: string, args: estree.BaseExpression[]): BasicConversionResult;
}
//# sourceMappingURL=regexp-converter.d.ts.map