/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PostgresDateConverter=void 0;const date_converter_1=require("./date-converter");class PostgresDateConverter extends date_converter_1.DateConverter{constructor(){super(...arguments),this.dateSqlFields={epoch:t=>`date_part('epoch', ${t})`,year:t=>`date_part('year', ${t})`,month:t=>`date_part('month', ${t})`,day:t=>`date_part('day', ${t})`,week:t=>`date_part('week', ${t})`,weekDay:t=>`date_part('dow', ${t})`,yearDay:t=>`date_part('doy', ${t})`,isLeapYear:t=>`(date_part('day', make_date(date_part('year', ${t})::int, 3, 1) - '1 day'::interval) = 29)`},this.currentDate="CURRENT_DATE"}convertAddIntervalCall(t,e,r,a){const[s]=this.convertArgs(e,["integer"],`date.${r}`),n=`(${t.sql} + (${s.sql}::INT4 || ' ' || '${a}')::interval)::DATE`;return{...t,type:"date",sql:n}}convertAddDaysCall(t,e){const[r]=this.convertArgs(e,["integer"],"date.addDays"),a=`(${t.sql} + ${r.sql}::INT4)::DATE`;return{...t,type:"date",sql:a}}convertDaysDiffCall(t,e){const[r]=this.convertArgs(e,["date"],"date.daysDiff"),a=`(${t.sql} - ${r.sql})::INT4`;return{...t,type:"integer",sql:a}}convertDaysInMonthCall(t,e){this.convertArgs(e,[],"date.daysInMonth");const r=`(date_part('day', date_trunc('month', ${t.sql}) + interval '1 month - 1 day'))`;return{...t,type:"integer",sql:r}}convertBegOfIntervalCall(t,e,r,a){this.convertArgs(e,[],`date.${r}`);const s=`date_trunc('${a}', ${t.sql})::DATE`;return{...t,type:"date",sql:s}}convertEndOfIntervalCall(t,e,r,a){this.convertArgs(e,[],`date.${r}`);let s=`1 ${a}`;if("quarter"===a)s="3 months";const n=`(date_trunc('${a}', ${t.sql}) + interval '${s} - 1 day')`;return{...t,type:"date",sql:n}}}exports.PostgresDateConverter=PostgresDateConverter;
//# sourceMappingURL=postgres-date-converter.js.map