/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.OracleDateConverter=void 0;const conversion_error_1=require("../../conversion-error"),date_converter_1=require("./date-converter");class OracleDateConverter extends date_converter_1.DateConverter{constructor(){super(...arguments),this.dateSqlFields={epoch:e=>`((${e} - TO_DATE('1970-01-01', 'YYYY-MM-DD')) * 86400)`,year:e=>`EXTRACT(YEAR FROM ${e})`,month:e=>`EXTRACT(MONTH FROM ${e})`,day:e=>`EXTRACT(DAY FROM ${e})`,week:e=>`TO_NUMBER(TO_CHAR(${e}, 'WW'))`,weekDay:e=>`(CASE to_char(${e},'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END)`,yearDay:e=>`TO_NUMBER(TO_CHAR(${e}, 'DDD'))`,isLeapYear:e=>`ADD_MONTHS(TRUNC(${e},'YEAR'),12)-TRUNC(${e},'YEAR')=366`},this.currentDate="SYSDATE"}convertAddIntervalCall(e,r,t,a){const[s]=this.convertArgs(r,["integer"],`date.${t}`);let o="";switch(a){case"year":o=`ADD_MONTHS(${e.sql}, ${s.sql} * 12)`;break;case"month":o=`ADD_MONTHS(${e.sql}, ${s.sql})`;break;case"week":o=`(${e.sql}+(${s.sql}*7))`;break;default:throw new conversion_error_1.ConversionError(void 0,`cannot convert call to date method ${t} to SQL for interval ${a}`)}return{...e,type:"date",sql:o}}convertAddDaysCall(e,r){const[t]=this.convertArgs(r,["integer"],"date.addDays"),a=`${e.sql} + ${t.sql}`;return{...e,type:"date",sql:a}}convertDaysDiffCall(e,r){const[t]=this.convertArgs(r,["date"],"date.daysDiff"),a=`(${e.sql} - ${t.sql})`;return{...e,type:"integer",sql:a}}convertDaysInMonthCall(e,r){this.convertArgs(r,[],"date.daysInMonth");const t=`1+TRUNC(LAST_DAY(${e.sql}))-TRUNC(${e.sql},'MM')`;return{...e,type:"integer",sql:t}}convertBegOfIntervalCall(e,r,t,a){this.convertArgs(r,[],`date.${t}`);let s="";switch(a){case"year":s=`TRUNC(${e.sql},'YEAR')`;break;case"month":s=`TRUNC(${e.sql},'MONTH')`;break;case"week":s=`TRUNC(${e.sql},'IW')`;break;case"quarter":s=`TRUNC(${e.sql},'Q')`;break;default:throw new conversion_error_1.ConversionError(void 0,`${this.dialect}: cannot convert call to date method ${t} to SQL for interval ${a}`)}return{...e,type:"date",sql:s}}convertEndOfIntervalCall(e,r,t,a){this.convertArgs(r,[],`date.${t}`);let s="";switch(a){case"year":s=`ADD_MONTHS(TRUNC(${e.sql}, 'Y'), 12) - 1`;break;case"month":s=`LAST_DAY(${e.sql})`;break;case"week":s=`TRUNC(${e.sql},'IW')+6`;break;case"quarter":s=`ADD_MONTHS(TRUNC(${e.sql},'Q'),3)-1`;break;default:throw new conversion_error_1.ConversionError(void 0,`${this.dialect}: cannot convert call to date method ${t} to SQL for interval ${a}`)}return{...e,type:"date",sql:s}}}exports.OracleDateConverter=OracleDateConverter;
//# sourceMappingURL=oracle-date-converter.js.map