/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.CollectionConverter=void 0;const _=require("lodash"),conversion_error_1=require("../conversion-error"),converter_1=require("../converter"),registry_1=require("../registry");class CollectionConverter{constructor(e){this.converter=e}convertCollectionCallback(e,r){const{callbacksResults:o,aliases:n,joinCondition:t}=this.convertCollectionCallbacks(e,{callback:r});return{callbackResult:o.callback,aliases:n,joinCondition:t}}convertQuantifiedCallback(e,r,o){const n=this.convertCollectionCallback(e,r),t=n.callbackResult.sql,i="every"===o?`NOT(${t})`:t,s=`(SELECT COUNT(*) FROM ${n.aliases} WHERE ${converter_1.Converter.and([n.joinCondition,i])})`;switch(o){case"some":return converter_1.Converter.booleanResult(`(${s} >= 1)`);case"every":return converter_1.Converter.booleanResult(`(${s} = 0)`);default:throw new conversion_error_1.ConversionError(void 0,`invalid quantifier: ${o}`)}}convertQuantifiedExpression(e,r,o){if(1!==r.length)throw new conversion_error_1.ConversionError(void 0,`cannot convert ${o}: expected 1 arg, got ${r.length}`);const n=r[0];if("ArrowFunctionExpression"!==n.type)throw new conversion_error_1.ConversionError(void 0,`cannot convert ${o}: expected arrow function, got ${n.type}`);return this.convertQuantifiedCallback(e,n,o)}convertSumCallbacks(e,r,o){const{callbacksResults:n,joinCondition:t,aliases:i}=this.convertCollectionCallbacks(e,{sum:o,...r&&{where:r}}),s=n.sum,c=n.where;if(r&&c)this.converter.checkResultType(r,c,"boolean");const l=converter_1.Converter.and([t,c?.sql]);return{type:s.type,sql:`(SELECT COALESCE(SUM(${s.sql}), 0) FROM ${i} WHERE ${l})`}}convertSumExpression(e,r){if(1!==r.length)throw new conversion_error_1.ConversionError(void 0,`cannot convert sum: expected 1 arg, got ${r.length}`);const o=r[0];if("ArrowFunctionExpression"!==o.type)throw new conversion_error_1.ConversionError(void 0,`cannot convert sum: expected arrow function, got ${o.type}`);return this.convertSumCallbacks(e,void 0,o)}convertCollectionCallbacks(e,r){let o="";return Object.values(r).forEach(e=>{if(1!==e.params.length||"Identifier"!==e.params[0].type)throw new conversion_error_1.ConversionError(e,`invalid parameters type is ${e.params[0].type} `);if(o&&e.params[0].name!==o)throw new conversion_error_1.ConversionError(e,`different parameter name ${o} - ${e.params[0].name}`);o=e.params[0].name}),this.converter.withSubQueryScope(()=>(this.converter.makeAliasAndJoin(e),this.converter.variableScope.set(o,{...e,type:"reference",property:void 0,sql:e.alias}),{callbacksResults:_.mapValues(r,e=>this.converter.convertArrowFunctionExpression(e))}))}convertTakeOneCallback(e,r){const o=r.params[0];if(!o||"Identifier"!==o.type)throw new conversion_error_1.ConversionError(o,"invalid parameter");const{aliases:n,joinCondition:t,innerAlias:i,callbackResult:s}=this.converter.withSubQueryScope(()=>(this.converter.makeAliasAndJoin(e),this.converter.variableScope.set(o.name,{...e,type:"reference",property:void 0,sql:e.alias}),{callbackResult:this.converter.convertArrowFunctionExpression(r)}));this.converter.checkResultType(r,s,"boolean");const c=`\n(SELECT ${i.alias}.*\n  FROM ${n}\n  WHERE ${s.sql}\n\n                        AND ${t} ORDER BY ${i.alias}._tenant_id, ${i.alias}._id  ASC LIMIT 1)`,l={...i,join:{...i.join,isNullable:true,lateral:c}};this.converter.pushAlias(l);const a={...e,path:this.converter.getUniquePath(e.path),type:"reference",isNullable:true,sql:`${l.alias}._id`};return this.converter.results.set(a.path,a),a}convertWhereExpression(e,r){if(r.length>1)throw new conversion_error_1.ConversionError(void 0,"too many arguments to collection.where call");const o=r[0];if(o&&"ArrowFunctionExpression"!==o.type)throw new conversion_error_1.ConversionError(o,"invalid callback");return{...e,extraType:"collectionWhere",whereCallback:o}}convertWhereSumExpression(e,r){if(r.length>1)throw new conversion_error_1.ConversionError(void 0,"too many arguments to sum call");const o=r[0];if(o&&"ArrowFunctionExpression"!==o.type)throw new conversion_error_1.ConversionError(o,"invalid callback");return this.convertSumCallbacks(e,e.whereCallback,o)}convertTakeOneExpression(e,r){if(r.length>1)throw new conversion_error_1.ConversionError(void 0,"too many arguments to sum call");const o=r[0];if(o&&"ArrowFunctionExpression"!==o.type)throw new conversion_error_1.ConversionError(o,"invalid callback");return this.convertTakeOneCallback(e,o)}convertLengthProperty(e){const r=this.converter.withSubQueryScope(()=>(this.converter.makeAliasAndJoin(e),{argResult:{type:"boolean",sql:"1"}}));return{type:"integer",sql:`(SELECT COUNT(*) FROM ${r.aliases} WHERE ${converter_1.Converter.and([r.joinCondition])})`}}static register(){registry_1.registry.registerMethods("collection",{every:(e,r,o)=>new CollectionConverter(e).convertQuantifiedExpression(r,o,"every"),some:(e,r,o)=>new CollectionConverter(e).convertQuantifiedExpression(r,o,"some"),takeOne:(e,r,o)=>new CollectionConverter(e).convertTakeOneExpression(r,o),where:(e,r,o)=>new CollectionConverter(e).convertWhereExpression(r,o),sum:(e,r,o)=>new CollectionConverter(e).convertSumExpression(r,o)}),registry_1.registry.registerProperties("collection",{length:(e,r)=>new CollectionConverter(e).convertLengthProperty(r)}),registry_1.registry.registerMethods("collectionWhere",{sum:(e,r,o)=>new CollectionConverter(e).convertWhereSumExpression(r,o)})}}exports.CollectionConverter=CollectionConverter;
//# sourceMappingURL=collection-converter.js.map