import * as estree from 'estree';
import { Converter } from '../converter';
import { BasicConversionResult } from '../types';
/**
 * Converts array expressions to SQL.
 */
export declare class ArrayConverter {
    private readonly converter;
    constructor(converter: Converter);
    /**
     * Converts a method call on an array literal to a SQL query.
     * @param object - The array literal expression.
     * @param methodName - The name of the method being called.
     * @param args - The arguments passed to the method.
     * @returns The result of the conversion.
     */
    convertLiteralMethodCall(object: estree.ArrayExpression, methodName: string, args: estree.BaseExpression[]): BasicConversionResult;
}
//# sourceMappingURL=array-converter.d.ts.map