import * as React from 'react';
import * as xtremRedux from './redux';
import type { ApplicationContext } from './redux/state';
export interface XtremUiIndexProps {
    path: string;
    applicationContext: ApplicationContext;
}
/**
 * Entry point of the Xtrem UI framework. Instantiates the react Providers, sets the application
 * context and renders the framework components
 */
export declare class XtremUiIndex extends React.Component<XtremUiIndexProps> {
    constructor(props: XtremUiIndexProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: XtremUiIndexProps): void;
    componentWillUnmount(): void;
    private setGlobalState;
    navigate(thunkDispatch: xtremRedux.AppThunkDispatch, path: string): Promise<void>;
    /** This method is used by xtrem-standalone */
    cleanToasts(): void;
    render(): React.ReactNode;
}
//# sourceMappingURL=xtrem-ui-index.d.ts.map