import * as React from 'react';
import { connect } from 'react-redux';
import { ConnectedDialogRouter } from './component/container/dialog/dialog-router';
// eslint-disable-next-line import/no-named-as-default
import LoadingDialog from './component/container/dialog/loading-dialog';
import PageComponent from './component/container/page/page-component';
import { ConnectedToastComponent } from './component/toast/toast-component';
import { ConnectedTableSidebar } from './component/table-sidebar/table-sidebar';
import { ContextType } from './types';
import { getPageBodyColumnCount } from './utils/responsive-utils';
import { getMainPageDefinitionFromState } from './utils/state-utils';
/** @internal */
class XtremController extends React.Component {
    renderBody() {
        const gridColumnCount = getPageBodyColumnCount(this.props.browserIs);
        if (this.props.pageDefinition && this.props.pageDefinition.isReady) {
            return (React.createElement(PageComponent, { key: this.props.pageDefinition.metadata.screenId, pageDefinition: this.props.pageDefinition, contextType: ContextType.page, availableColumns: gridColumnCount }));
        }
        return null;
    }
    render() {
        const cssClasses = 'e-xtrem-controller';
        return (React.createElement("div", { className: cssClasses, style: !this.props.path ? { display: 'none' } : {} },
            this.renderBody(),
            React.createElement(ConnectedDialogRouter, null),
            this.props.loading && React.createElement(LoadingDialog, null),
            this.props.toasts.map(toast => (React.createElement(ConnectedToastComponent, { key: toast.id, toast: toast }))),
            React.createElement(ConnectedTableSidebar, null)));
    }
}
/** @internal */
const mapStateToProps = (state) => ({
    path: state.path,
    browserIs: state.browser.is,
    loading: state.loading.globalLoading,
    toasts: state.toasts,
    pageDefinition: getMainPageDefinitionFromState(state),
});
/** @internal */
export const ConnectedXtremController = connect(mapStateToProps)(XtremController);
//# sourceMappingURL=xtrem-controller.js.map