import type { Dict } from '@sage/xtrem-shared';
export declare const isNumber: (value?: any) => value is number;
type PathType = Array<string | number>;
type CollectionCallback<ValueType, AccumulatorType, SourceType> = (value: ValueType, acc: AccumulatorType, key: string | number, path: PathType, source: SourceType) => [ValueType, PathType];
type ValueCallback<ValueType, AccumulatorType, SourceType> = (value: ValueType, acc: AccumulatorType, key: string | number, path: PathType, source: SourceType) => AccumulatorType;
type onArray<AccumulatorType, SourceType> = CollectionCallback<Array<any>, AccumulatorType, SourceType>;
type onObject<AccumulatorType, SourceType> = CollectionCallback<Dict<any>, AccumulatorType, SourceType>;
type onValue<AccumulatorType, SourceType> = ValueCallback<any, AccumulatorType, SourceType>;
export declare const reduceDict: <SourceType, AccumulatorType>() => (source: SourceType, initial: AccumulatorType, onValueFn: onValue<AccumulatorType, SourceType>, onObjectFn?: onObject<AccumulatorType, SourceType>, onArrayFn?: onArray<AccumulatorType, SourceType>) => AccumulatorType;
export declare const AllAndOnly: <T>() => <U extends T[]>(array: U & ([T] extends [U[number]] ? unknown : never)) => U & ([T] extends [U[number]] ? unknown : never);
export {};
//# sourceMappingURL=type-utils.d.ts.map