import type { Dict } from '@sage/xtrem-shared';
import type { EditableFieldProperties } from '../component/editable-field-control-object';
import type { EditableFieldComponentProperties, FieldComponentExternalProperties } from '../component/field/field-base-component-types';
import type { HasOptionType, HasOptions } from '../component/field/traits';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { NestedExtensionField } from '../component/nested-fields-extensions';
import type { CardExtensionDefinition } from '../component/ui/card/card-component';
import * as xtremRedux from '../redux';
import type { Page } from '../service/page';
import type { ScreenBase } from '../service/screen-base';
import type { NodePropertyType } from '../types';
import type { ArtifactDescription } from '../types/artifact-description';
/**
 * Converts object to have unique ids using fieldname__key
 */
export declare function mergedValueToSplitValue<T extends Object>(mergedValue: T): T;
/**
 * Converts the object to a normal normal value without __ (see mergedValueToSplitValue)
 */
export declare function splitValueToMergedValue<T extends Object>(splitValue: T): T;
export declare const hexToRgb: (hex: string) => {
    r: number;
    g: number;
    b: number;
} | null;
export declare const serializeDataForTransientPage: (screenId: string, useBindKeys?: boolean, isRequestingDefaults?: boolean) => any;
export declare const parseScreenValues: (screenId: string, useBindKeys?: boolean, isRequestingDefaults?: boolean, state?: xtremRedux.XtremAppState) => Dict<any>;
export declare const getScreenValues: (screenId: string, useBindKeys?: boolean) => Dict<any>;
export declare const capitalize: (s: string) => string;
export declare const pascalCase: (s: string) => string;
export declare function schemaTypeNameFromNodeName(name: NodePropertyType): string;
export declare function schemaTypeNameFromNodeName(name?: NodePropertyType): undefined | string;
export declare const getArtifactDescription: (path: string) => ArtifactDescription;
export declare const cleanMetadataFromRecord: (record: any, removeAction?: boolean, removeSortValue?: boolean) => any;
export declare const cleanMetadataAndNonPersistentIdFromRecord: (record: any) => any;
export interface FieldPropsWithOptions extends EditableFieldComponentProperties<EditableFieldProperties & HasOptionType & HasOptions<any>, any>, FieldComponentExternalProperties {
}
export declare const addOptionsAndLocalizationToProps: <T extends FieldPropsWithOptions>(state: xtremRedux.XtremAppState, baseProps: T) => T & {
    localizedOptions?: Dict<string>;
    enumOptions?: string[];
};
export declare const getNestedFieldArrayFromCardDefinition: <T extends NestedFieldTypes>(cardDefinition: Dict<NestedField<any, T> | undefined>) => NestedField<Page, T>[];
export declare const getNestedFieldArrayFromCardExtensionDefinition: <T extends NestedFieldTypes>(cardDefinition: CardExtensionDefinition) => NestedExtensionField<Page, T>[];
export declare const arrayMoveMutate: (array: any[], from: number, to: number) => void;
export declare function forceReadOnlyModeOnNestedField<T extends NestedField<ScreenBase, NestedFieldTypes> | undefined>(nestedField: T): T;
/**
 * Not a pure function, mutates the value. Deep clean is advised before calling.
 *
 * Removes nested structures that only contain keys with null values.
 * For example: { _id: 3, code: "Test", site: { country: null, site: { name: null } } } becomes just { _id: 3, code: "Test" }
 * See XT-30693 for more details.
 * @param data
 * @returns
 */
export declare const removeNullOnlyLeaves: (data: Object) => boolean;
//# sourceMappingURL=transformers.d.ts.map