import type { ColDef, GridApi } from '@ag-grid-community/core';
import { type Dict } from '@sage/xtrem-shared';
import type { OptionsMenuItem } from '../component/control-objects';
import type { TableDecoratorProperties, TableProperties } from '../component/field/table/table-component-types';
import type { OrderByType } from '../component/types';
import type { CardDefinition } from '../component/ui/card/card-component';
import type { TableView, TableViewGrouping, TableViewSortedColumn } from '../redux/state';
import type { ValueOrCallback } from './types';
export declare const AUTO_COLUMN_ID = "ag-Grid-AutoColumn";
export declare const getGraphFilter: ({ filterModel, screenId, tableFieldProperties, activeOptionsMenuItem, }: {
    filterModel: any;
    screenId: string;
    tableFieldProperties: TableProperties;
    activeOptionsMenuItem?: OptionsMenuItem;
}) => any;
export declare const isColumnBindVariant: (colBind: string, colId: string) => boolean;
export interface ColumnCompareType {
    bind: string;
    valueField?: string;
}
export declare const resolveCompareFunction: (screenId: string, compareFunc: Function, arg1: ColumnCompareType, arg2: ColumnCompareType) => number;
export declare const getOrderByKey: (columnId: string) => string;
export declare const removeNumericPostfix: (colId: string) => string;
export declare const removeTableNumericPostfix: (colId: string) => string;
/** Converts Ag-grid filter statements to Xtrem's GraphQL-friendly filter object structure */
export declare const getOrderByFromSortModel: (sortModel: TableViewSortedColumn[], columns: any[], autoGroupColumnDef?: ColDef) => OrderByType;
interface ShouldRenderDropdownAboveProps {
    isPhantomRow: boolean;
    pageSize: number;
    rowIndex: number;
}
export declare const shouldRenderDropdownAbove: ({ isPhantomRow, pageSize, rowIndex, }: ShouldRenderDropdownAboveProps) => boolean;
export declare const calculateHiddenColumns: import("memoize-one").MemoizedFn<(hiddenColumns: string[], actualColumns: (string | undefined | null)[]) => (string | null | undefined)[]>;
export interface GetCardDefinitionFromColumnsArgs {
    screenId: string;
    columns: TableDecoratorProperties['columns'];
    isGreaterThanSmall: boolean;
    hiddenColumns?: string[];
    sortColumns?: (this: any, firstColumn: ColumnCompareType, secondColumn: ColumnCompareType) => number;
    mobileCard?: TableDecoratorProperties['mobileCard'];
}
export declare const getCardDefinitionFromColumns: ({ screenId, columns, isGreaterThanSmall, hiddenColumns, sortColumns, mobileCard, }: GetCardDefinitionFromColumnsArgs) => CardDefinition;
export declare function setGridContext<T = any>(gridApi: GridApi, contextProducer: (c: T) => void): void;
type TableContext = {
    headerClasses: Dict<boolean>;
    onSelectAll: (selectedRowCount: number) => void;
    onUnselectAll: () => void;
    totalRowCount: number;
    isSelectAllEnabled: boolean;
};
export declare function setTableContext(gridApi: GridApi, contextProducer: (c: TableContext) => void): void;
export declare function getGridApiContext<T = any>(gridApi: GridApi, defaultValue: T): T;
export declare function getTableContext(gridApi: GridApi): TableContext;
type NestedGridContext = {
    parentId?: string;
    level?: number;
    parentApi?: GridApi;
    headerClasses: Dict<boolean>;
};
export declare function getNestedGridContext(gridApi: GridApi): NestedGridContext;
export declare function setNestedGridContext(gridApi: GridApi, contextProducer: (c: NestedGridContext) => void): void;
export declare const getTableViewColumnHidden: (views?: Dict<TableView>, level?: number) => Dict<boolean> | undefined;
export declare const getTableViewFilter: (views?: Dict<TableView>, level?: number) => Dict<any>;
export declare const getTableViewGrouping: (views?: Dict<TableView>, level?: number) => TableViewGrouping | undefined;
export declare const getTableViewOptionsMenuItem: (views?: Dict<TableView>, level?: number) => OptionsMenuItem | undefined;
export declare const getTableViewSortOrder: (views?: Dict<TableView>, level?: number) => TableViewSortedColumn[] | undefined;
export declare const getActiveOptionsMenu: (screenId: string, views?: Dict<TableView>, optionsMenu?: ValueOrCallback<any, OptionsMenuItem[]>) => OptionsMenuItem | undefined;
export {};
//# sourceMappingURL=table-component-utils.d.ts.map