import { navigationPanelId } from '../component/container/navigation-panel/navigation-panel-types';
import { AbstractUiControlObject, SectionControlObject } from '../component/control-objects';
import * as xtremRedux from '../redux';
import { xtremConsole } from './console';
import { convertDeepBindToPathNotNull } from './nested-field-utils';
import { resolveByValue } from './resolve-value-utils';
export const isScreenDefinitionDirty = (screenDefinition) => !screenDefinition.metadata.uiComponentProperties[screenDefinition.metadata.screenId].skipDirtyCheck &&
    !!Object.keys(screenDefinition.dirtyStates).find(key => screenDefinition.dirtyStates[key] === true) &&
    screenDefinition.type !== 'sticker';
export const hasAnyDirtyScreenDefinitions = (state) => !!Object.keys(state.screenDefinitions).find(screenId => isScreenDefinitionDirty(state.screenDefinitions[screenId])) ||
    !!Object.values(state.dashboard.dashboardGroups).find(group => group.dashboardEditor.isDirty || group.widgetEditor.isDirty) ||
    isSidebarDirty(state);
export const getPageDefinitionFromState = (screenId, state = xtremRedux.getStore().getState()) => {
    const pageDefinition = getPageDefinition(screenId, state);
    if (!pageDefinition) {
        throw new Error(`No page definition found: ${screenId}`);
    }
    return pageDefinition;
};
export const getPageDefinition = (screenId, state = xtremRedux.getStore().getState()) => {
    return state.screenDefinitions[screenId];
};
export const getMainPageDefinitionFromState = (state = xtremRedux.getStore().getState()) => Object.keys(state.screenDefinitions)
    .filter(key => state.screenDefinitions[key].type === 'page')
    .map(key => state.screenDefinitions[key])
    .find(definition => definition.isMainPage);
export const getPagePropertiesFromState = (screenId, state = xtremRedux.getStore().getState()) => {
    const properties = getPageDefinitionFromState(screenId, state).metadata.uiComponentProperties[screenId];
    if (!properties) {
        xtremConsole.error(getPageDefinitionFromState(screenId, state));
        throw new Error(`No properties found for page: ${screenId}`);
    }
    return properties;
};
export const getPageControlObjectFromState = (screenId, state = xtremRedux.getStore().getState()) => getPageDefinitionFromState(screenId, state).metadata.controlObjects[screenId] || null;
export const getPagePropertiesFromPageDefinition = (pageDefinition) => pageDefinition.metadata.uiComponentProperties[pageDefinition.metadata.screenId];
export const getNavigationPanelState = (screenId, state = xtremRedux.getStore().getState()) => state.screenDefinitions[screenId]?.navigationPanel || null;
export const getNavigationPanelDefinitionFromState = (screenId, state = xtremRedux.getStore().getState()) => getPagePropertiesFromState(screenId, state).navigationPanel || null;
export const getNavigationPanelTablePropertiesFromPageDefinition = (pageDefinition) => pageDefinition.metadata.uiComponentProperties[navigationPanelId];
export const checkIfPageIsLoaded = (screenId, state = xtremRedux.getStore().getState()) => {
    if (!getPageDefinitionFromState(screenId, state)) {
        throw new Error(`${screenId} page has already been destroyed, further operations are not allowed.`);
    }
};
export const arePlatformLiteralsMissing = (state = xtremRedux.getStore().getState(), locale = state.applicationContext?.locale || 'en-US') => !state.translations ||
    !state.translations[locale] ||
    !Object.keys(state.translations[locale]).find(key => key.startsWith('@sage/xtrem-ui'));
export const getSidebarTableProperties = ({ elementId, pageDefinition, level, }) => {
    const tableProperties = level === undefined
        ? pageDefinition.metadata.uiComponentProperties[elementId]
        : pageDefinition.metadata.uiComponentProperties[elementId].levels[level];
    if (!tableProperties.sidebar) {
        throw new Error(`No sidebar is defined for element with ID ${elementId}`);
    }
    return tableProperties;
};
export const getSidebarLayoutDefinitionFromState = (state = xtremRedux.getStore().getState()) => {
    if (!state.sidebar?.screenId || !state.sidebar.elementId) {
        return {};
    }
    const pageDefinition = getPageDefinitionFromState(state.sidebar.screenId, state);
    const tableProperties = getSidebarTableProperties({
        pageDefinition,
        elementId: state.sidebar.elementId,
        level: state.sidebar.level,
    });
    return resolveByValue({
        screenId: state.sidebar.screenId,
        propertyValue: tableProperties.sidebar.layout,
        rowValue: null,
        fieldValue: null,
        skipHexFormat: true,
    });
};
export const getSidebarNormalFields = (state = xtremRedux.getStore().getState()) => {
    const collector = [];
    const layoutDefinition = getSidebarLayoutDefinitionFromState(state);
    Object.keys(layoutDefinition || {}).forEach(sectionKey => {
        Object.keys(layoutDefinition[sectionKey].blocks || []).forEach(blockKey => {
            (layoutDefinition[sectionKey].blocks[blockKey].fields || []).forEach(f => {
                if (f instanceof AbstractUiControlObject) {
                    collector.push(f);
                }
            });
        });
    });
    return collector;
};
export const getSidebarNestedFields = (state = xtremRedux.getStore().getState()) => {
    const collector = [];
    const layoutDefinition = getSidebarLayoutDefinitionFromState(state);
    Object.keys(layoutDefinition || {}).forEach(sectionKey => {
        Object.keys(layoutDefinition[sectionKey].blocks || []).forEach(blockKey => {
            (layoutDefinition[sectionKey].blocks[blockKey].fields || []).forEach(f => {
                if (!(f instanceof AbstractUiControlObject)) {
                    collector.push(convertDeepBindToPathNotNull(f));
                }
            });
        });
    });
    return collector;
};
export const isSidebarDirty = (state = xtremRedux.getStore().getState()) => {
    if (!state.sidebar) {
        return false;
    }
    const tableValue = state.screenDefinitions[state.sidebar.screenId].values[state.sidebar.elementId];
    const records = tableValue.getData({
        isUncommitted: true,
        includePhantom: true,
        cleanMetadata: false,
        ...(state.sidebar.recordId ? { level: state.sidebar.level } : {}),
        parentId: null,
        where: {
            ...(state.sidebar.recordId ? { _id: state.sidebar.recordId } : { __phantom: true }),
        },
    });
    if (records?.[0]?.__dirtyColumns && (records?.[0]?.__dirtyColumns).size > 0) {
        return true;
    }
    const normalFields = getSidebarNormalFields(state);
    const screenId = state.sidebar.screenId;
    return !!normalFields.find(n => state.screenDefinitions[screenId].dirtyStates[n.id]);
};
export const getVisibleSectionsFromPage = (screenId, screenDefinition = xtremRedux.getStore().getState().screenDefinitions[screenId]) => Object.values(screenDefinition.metadata.controlObjects).filter(controlObject => controlObject instanceof SectionControlObject &&
    !resolveByValue({
        screenId,
        skipHexFormat: true,
        propertyValue: controlObject.properties.isHidden,
        rowValue: null,
        fieldValue: null,
    }));
//# sourceMappingURL=state-utils.js.map