import type { DialogSizes } from 'carbon-react/esm/components/dialog/dialog.config';
import type { ComponentKey, ContainerWidth, FieldWidth } from '../component/types';
import type { ReduxResponsive, ResponsiveTypes } from '../redux/state';
import type { Breakpoints } from '../render/responsive-breakpoints';
export interface ScreenSize extends Breakpoints {
    infinity: number;
}
export declare const DEFAULT_FIELD_SIZE: number;
export declare const COLUMN_COUNT_HELPER_PANEL: number;
export declare const COLUMN_COUNT_PAGE_BODY: ScreenSize;
export declare const MARGIN_SIZE_PAGE_BODY: ScreenSize;
export declare const GUTTER_SIZE_PAGE_BODY: ScreenSize;
export declare const FIELD_SIZE: {
    'extra-large': ScreenSize;
    large: ScreenSize;
    medium: ScreenSize;
    small: ScreenSize;
};
export declare enum CONTAINER_SIZE_NAMING {
    extraLarge = "extra-large",
    large = "large",
    medium = "medium",
    small = "small",
    extraSmall = "extra-small"
}
export declare const CONTAINER_SIZE: {
    [key in CONTAINER_SIZE_NAMING]: ScreenSize;
};
export declare const getPageBodyColumnCount: (is: ResponsiveTypes) => number;
export declare const getPageBodyMarginSize: (is: ResponsiveTypes) => number;
export declare const getGutterSize: (is: ResponsiveTypes) => number;
export declare const calculateContainerWidth: (is: ResponsiveTypes, availableColumnNum: number, setContainerWidth?: ContainerWidth) => any;
export declare const calculateFieldWidth: (is: ResponsiveTypes, fieldType: ComponentKey, availableColumnNum?: number, isFieldFullWidth?: boolean, setFieldNum?: FieldWidth) => number;
export declare const getMaxDialogSize: (browser: ReduxResponsive) => DialogSizes;
//# sourceMappingURL=responsive-utils.d.ts.map