import type { ClientNode } from '@sage/xtrem-client';
import type { CalendarProperties, PodCollectionDecoratorProperties, TableProperties } from '../component/control-objects';
import type { PropertyValueType } from '../component/field/reference/reference-types';
import type { InternalTableProperties } from '../component/field/table/table-component-types';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { GridLodable } from '../service/collection-data-service';
import type { ScreenBase } from '../service/screen-base';
export declare const isNestedField: (maybeNestedField: any) => boolean;
export type NestedFieldPropertyType = GridLodable | TableProperties | InternalTableProperties | CalendarProperties | PodCollectionDecoratorProperties;
export declare const getNestedFieldsFromProperties: <T extends ClientNode = any>(properties: NestedFieldPropertyType) => NestedField<any, any, T>[];
/**
 * Resolve title field from a card definition to a display string value.
 */
export declare const getImagePlaceholderValue: (record: any, titleField: NestedField<ScreenBase, NestedFieldTypes>) => string | undefined;
/**
 * Turn nested bind property reference object to dot-notion reference. For example, it converts `{this:{is:{a:{nested:{bind:true}}}}}`
 * to `this.is.a.nested.bind`.
 * @param path string or deep bind object
 * @returns dot notion deep reference string
 */
export declare const convertDeepBindToPath: (path?: string | PropertyValueType | boolean) => string | null;
/**
 * Same as convertDeepBindToPath, but throws an error if the value is null or undefined.
 * @param path
 */
export declare const convertDeepBindToPathNotNull: (path?: string | PropertyValueType | boolean) => string;
/**
 * Returns to first component of a nested bind property For example, it converts `hi`, `hi.there` and `{hi:{there:true}}` to `hi`.
 * @param path
 * @returns top level property name
 */
export declare const getTopLevelBindFromNestedBindNotNull: (path?: string | PropertyValueType) => string;
/**
 * Returns to first component of a nested bind property For example, it converts `hi`, `hi.there` and `{hi:{there:true}}` to `hi`.
 * @param path
 * @returns top level property name
 */
export declare function getTopLevelBindFromNestedBind(path: string | PropertyValueType): string;
export declare function getTopLevelBindFromNestedBind(path: undefined | PropertyValueType): undefined;
//# sourceMappingURL=nested-field-utils.d.ts.map