import { get } from 'lodash';
import { AggregateControlObject, CountControlObject, DateControlObject, DropdownListControlObject, LabelControlObject, NumericControlObject, ReferenceControlObject, SelectControlObject, TextControlObject, } from '../component/control-objects';
import { getReferenceValueField } from '../component/field/reference/reference-utils';
import { localizeEnumMember } from '../service/i18n-service';
import { getScreenElement } from '../service/screen-base-definition';
import { formatNumericValue } from './formatters';
import { getPagePropertiesFromPageDefinition } from './state-utils';
import { formatDateToCurrentLocale } from '@sage/xtrem-date-time';
export const getFieldDisplayValue = (pageDefinition, field, locale) => {
    const value = field.value;
    if (value === null || value === '' || value === undefined) {
        return null;
    }
    const properties = pageDefinition.metadata.uiComponentProperties[field.id];
    if (field instanceof TextControlObject) {
        return value;
    }
    if (field instanceof CountControlObject) {
        return formatNumericValue({ screenId: pageDefinition.metadata.screenId, value, scale: 0, locale });
    }
    if (field instanceof NumericControlObject || field instanceof AggregateControlObject) {
        return formatNumericValue({ screenId: pageDefinition.metadata.screenId, value, scale: field.scale, locale });
    }
    if (field instanceof ReferenceControlObject) {
        return get(value, getReferenceValueField(properties));
    }
    if (field instanceof DateControlObject) {
        return formatDateToCurrentLocale(value, locale);
    }
    const selectProperties = properties;
    if ((field instanceof SelectControlObject ||
        field instanceof DropdownListControlObject ||
        field instanceof LabelControlObject) &&
        selectProperties.optionType) {
        return localizeEnumMember(selectProperties.optionType, String(value));
    }
    return String(value);
};
export const getIdFieldValue = (pageDefinition, locale) => {
    const pageProperties = getPagePropertiesFromPageDefinition(pageDefinition);
    if (!pageProperties.idField) {
        return null;
    }
    const idField = pageProperties.idField.apply(getScreenElement(pageDefinition));
    if (!idField) {
        return null;
    }
    if (typeof idField === 'string') {
        return idField;
    }
    const idFieldArray = idField instanceof Array ? idField : [idField];
    const value = idFieldArray
        .map(f => getFieldDisplayValue(pageDefinition, f, locale))
        .filter(f => !!f)
        .join(' ')
        .trim();
    return value || null;
};
//# sourceMappingURL=id-field-utils.js.map