import { useEffect } from 'react';
import { useFirstMountState } from './use-first-mount-state';
import { useDeepCompareEffect } from '@sage/xtrem-ui-components';
const useUpdateEffect = (effect, deps) => {
    const isFirstMount = useFirstMountState();
    // eslint-disable-next-line consistent-return
    useEffect(() => {
        if (!isFirstMount) {
            return effect();
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [deps, isFirstMount]);
};
function useDeepCompareUpdateEffect(effect, deps) {
    const isFirstMount = useFirstMountState();
    // eslint-disable-next-line consistent-return
    useDeepCompareEffect(() => {
        if (!isFirstMount) {
            return effect();
        }
    }, deps);
}
export { useUpdateEffect, useDeepCompareUpdateEffect };
//# sourceMappingURL=use-update-effect.js.map