import { DateValue } from '@sage/xtrem-date-time';
import type { ScreenBase } from '../service/screen-base';
import type { DatePropertyValue, DateTimePropertyValue, ValueOrCallbackWithFieldValue } from './types';
export declare const getIsoDate: (date: DatePropertyValue | undefined | null) => string | undefined;
export declare const isInvalidJsDate: (jsDate: Date) => boolean;
export declare const dateToString: (date: Date, dateFieldFormat?: string) => string;
export declare const isDateOrDateTime: (value: DatePropertyValue | DateTimePropertyValue) => 'date' | 'datetime' | null;
export declare const getFirstDayOfMonth: (date: DateValue) => DateValue;
export declare const getLastDayOfMonth: (date: DateValue) => DateValue;
export interface FormatNumericValueArgs {
    screenId: string;
    value: any;
    ignoreLocale?: boolean;
    scale?: ValueOrCallbackWithFieldValue<ScreenBase, number, number>;
    rowValue?: any;
    locale?: string;
}
export declare const formatNumericValue: ({ screenId, value, ignoreLocale, scale, rowValue, locale, }: FormatNumericValueArgs) => string;
export declare const parseLocalizedNumberStringToNumber: (value: string | null | undefined | number, separator: string) => number | null;
interface NumberComponents {
    integer: string;
    decimal: string;
    separator: string;
    sign: '+' | '-';
}
export declare const getNumberComponentsFromLocalizedNumberString: (value: string | null | undefined | number, separator: string) => NumberComponents;
export declare function humanFileSize(size: number): string;
export {};
//# sourceMappingURL=formatters.d.ts.map