import { convertDeepBindToPath } from './nested-field-utils';
import { section } from '../component/container/section/section-decorator';
import { block } from '../component/container/block/block-decorator';
const mapDuplicateKeyToLayoutProperty = (pageDefinition) => (bind) => {
    // Find the corresponding field property name by searching for the bind decorator property
    const $bind = Object.keys(pageDefinition.metadata.uiComponentProperties).find((key) => {
        const fieldProperties = pageDefinition.metadata.uiComponentProperties[key];
        return convertDeepBindToPath(fieldProperties.bind) === bind || (!fieldProperties.bind && key === bind);
    });
    if (!$bind) {
        throw new Error(`Could not find duplicate field definition for ${bind}`);
    }
    return {
        $bind,
        $containerType: 'block',
        $isFullWidth: false,
    };
};
/**
 * Replaces the page's business actions with the duplicate actions
 * It mutates the pageDefinition object
 * */
export function applyDuplicationBusinessActions(pageDefinition) {
    pageDefinition.metadata.businessActionsThunk = () => {
        return [
            pageDefinition.metadata.controlObjects.$standardCancelAction,
            pageDefinition.metadata.controlObjects.$standardExecuteDuplicationAction,
        ];
    };
}
/**
 * Replaces the page's layout with a single section that contains only the fields which are required for duplication
 * It mutates the pageDefinition object
 * */
export function applyDuplicationLayoutStructure(pageDefinition) {
    const duplicateBindings = pageDefinition.metadata.duplicateBindings || [];
    pageDefinition.metadata.layout = {
        $items: [
            {
                $containerId: '$duplicateSection', // TODO: MAKE THIS A CONSTANT
                $isHiddenMobile: false,
                $isHiddenDesktop: false,
                $category: 'section',
                $layout: {
                    $items: [
                        {
                            $containerId: '$duplicateBlock', // TODO: MAKE THIS A CONSTANT
                            $isHiddenMobile: false,
                            $isHiddenDesktop: false,
                            $category: 'block',
                            $layout: {
                                $items: duplicateBindings.map(mapDuplicateKeyToLayoutProperty(pageDefinition)),
                            },
                        },
                    ],
                },
            },
        ],
    };
}
/**
 * Add a section and a block control object to the page definition
 * @param pageMetadata
 * @returns
 */
export function addDuplicationLayoutContainers(pageMetadata) {
    if (!pageMetadata?.target) {
        return;
    }
    section({ isTitleHidden: true })(pageMetadata.target, '$duplicateSection');
    block({
        isTitleHidden: true,
        parent() {
            return this._duplicateSection;
        },
    })(pageMetadata.target, '$duplicateBlock');
}
//# sourceMappingURL=duplication-utils.js.map