import type { ResponsiveProperties } from '../component/abstract-ui-control-object';
import type { EditableFieldProperties } from '../component/editable-field-control-object';
import type { BaseEditableComponentProperties } from '../component/field/field-base-component-types';
import type { ReadonlyFieldProperties } from '../component/readonly-field-control-object';
import type { FieldKey, FieldValue } from '../component/types';
import type { ReduxResponsive } from '../redux/state';
import type { PageArticleItem } from '../service/layout-service';
import type { ContextType } from '../types';
export declare function scrollWithAnimationTo(element: HTMLElement, container: HTMLElement, offset?: number): void;
export declare function isHidden(hiddenProperties?: Partial<PageArticleItem> | ResponsiveProperties, browser?: ReduxResponsive): boolean;
export declare const getDataTestIdAttribute: (fieldType: string, label?: string, elementId?: string | object, prefix?: string) => string;
export declare const getComponentClass: (props: Partial<BaseEditableComponentProperties<ReadonlyFieldProperties, FieldValue<FieldKey>>>, specificClassNames: string, rowValue?: any) => string;
export declare const getFieldClass: (screenId: string, fieldValue: any, classNames: string, fieldProperties: EditableFieldProperties, hasValidationErrors?: boolean, isFieldHidden?: boolean, rowValue?: {}, contextType?: ContextType) => string;
export declare const copyToClipboard: (content: string) => void;
export declare function focusTopPage(): void;
export declare const focusPageContent: () => void;
/** For mocking purposes */
export declare const getNewFileReader: () => FileReader;
export declare const getTabControlElement: () => HTMLElement | null;
export declare const isScrolledToTheEnd: (element: HTMLElement) => boolean;
export declare const isChildOfElementWithClass: (element: Element | Document, className: string) => boolean;
export declare const isChildOfElementWithAttributeValue: (element: Element | Document, attributeName: string, attributeValue: string) => boolean;
export declare const findAncestorDatasetProperty: (element: HTMLElement, datasetPropertyName: string) => string | null;
//# sourceMappingURL=dom.d.ts.map