import { date } from '@sage/xtrem-date-time';
export function isRowValueInDateGroup(rowValue, groupValue, aggFunc) {
    const dateValue = date.parse(rowValue);
    const groupDate = date.parse(groupValue);
    const isSameYear = () => dateValue.year === groupDate.year;
    const isSameMonth = () => dateValue.month === groupDate.month;
    const isSameDay = () => dateValue.day === groupDate.day;
    if (aggFunc === 'year') {
        return isSameYear();
    }
    if (aggFunc === 'month') {
        return isSameYear() && isSameMonth();
    }
    if (aggFunc === 'day') {
        return isSameYear() && isSameMonth() && isSameDay();
    }
    return false;
}
export function getTimezoneUtcOffsetByCity(timeZone) {
    const formatter = new Intl.DateTimeFormat([], { timeZoneName: 'longOffset', timeZone });
    const dummyDate = formatter.format(new Date());
    const parts = dummyDate.split(', GMT');
    return `GMT${parts[1] || ''}`;
}
//# sourceMappingURL=date-utils.js.map