import { type Dict } from '@sage/xtrem-shared';
import type { ComponentProperties } from '../component/base-control-object';
import type { HasColumns, HasHelperTextField, HasImageField, HasMaxMin, HasMaxMinLength, HasNode, HasOptionType, HasScale, HasValueField } from '../component/field/traits';
import * as nestedFields from '../component/nested-fields';
import type { DataTypeDetails, DataTypeProperty, FormattedNodeDetails, NodeDetailsProperty } from '../service/metadata-types';
import type { ValueOrCallbackWithFieldValue } from './types';
import type { NestedFieldTypes } from '../component/nested-fields';
import type { CardDefinition } from '../component/ui/card/card-component';
import type { TableProperties } from '../component/field/field-properties';
import type { MarkOptional } from 'ts-essentials';
export interface AutomaticFieldConfigurationArgs<T> {
    propertyDetails: NodeDetailsProperty;
    dataType: DataTypeDetails;
    properties: T;
}
export interface AutomaticFieldConfigurationArgsWithSchemaInfo<T> extends AutomaticFieldConfigurationArgs<T> {
    nodeTypes: Dict<FormattedNodeDetails>;
    dataTypes: Dict<DataTypeDetails>;
}
export declare function getCardDefinitionFromReferenceDataType({ dataType, dataTypes, nodeTypes, contextNode, }: {
    nodeTypes: Dict<FormattedNodeDetails>;
    dataTypes: Dict<DataTypeDetails>;
    dataType: DataTypeDetails;
    contextNode: string;
}): CardDefinition<any>;
export declare function applyDefaultValuesOnNestedField(nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, field?: nestedFields.NestedField<any, NestedFieldTypes>, contextNode?: string): void;
export declare function createNestedFieldFromDataTypeProperty(prop: DataTypeProperty, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, contextNode: string): nestedFields.NestedField<any, any>;
export declare function addTitleToProperties({ propertyDetails, properties, }: Omit<AutomaticFieldConfigurationArgs<{
    title?: ValueOrCallbackWithFieldValue<any, string>;
}>, 'dataType'>): void;
export declare function addIsTransientInput({ propertyDetails, properties, }: AutomaticFieldConfigurationArgs<{
    isTransientInput?: boolean;
}>): void;
export declare function addMaxLengthToProperties({ dataType, properties, }: AutomaticFieldConfigurationArgs<HasMaxMinLength<any>>): void;
export declare function addOptionTypeToProperties({ propertyDetails, properties, }: AutomaticFieldConfigurationArgs<HasOptionType>): void;
export declare function addScaleToProperties({ dataType, properties, }: AutomaticFieldConfigurationArgs<HasScale<any, any>>): void;
export declare function addMaxMinToProperties({ dataType, properties }: AutomaticFieldConfigurationArgs<HasMaxMin<any>>): void;
export declare function addNodeToProperties({ propertyDetails, properties, }: AutomaticFieldConfigurationArgs<HasNode<any>>): void;
export declare function addTunnelPageToProperties({ dataType, properties, }: AutomaticFieldConfigurationArgs<{
    tunnelPage?: string;
}>): void;
export declare function addDisabledToProperties({ propertyDetails, properties, }: MarkOptional<AutomaticFieldConfigurationArgs<ComponentProperties<any>>, 'propertyDetails' | 'dataType'>): void;
export declare function addColumnsToProperties({ dataType, propertyDetails, properties, nodeTypes, dataTypes, }: AutomaticFieldConfigurationArgsWithSchemaInfo<Partial<HasColumns<any, any, nestedFields.NestedFieldTypes>>>, ignoreCardDefinition?: boolean): void;
export declare function addMobileCardDefinitionToProperties({ dataType, propertyDetails, properties, nodeTypes, dataTypes, }: AutomaticFieldConfigurationArgsWithSchemaInfo<Partial<TableProperties<any>>>): void;
export declare function addValueFieldToProperties({ dataType, propertyDetails, properties, }: AutomaticFieldConfigurationArgs<Partial<HasValueField<any>>>): void;
export declare function addHelperTextFieldToProperties({ dataType, propertyDetails, properties, }: AutomaticFieldConfigurationArgs<Partial<HasHelperTextField<any>>>): void;
export declare function addImageFieldToProperties({ dataType, propertyDetails, properties, }: AutomaticFieldConfigurationArgs<Partial<HasImageField<any>>>): void;
export declare function createDynamicPodReferenceField({ column, nodeTypes, dataTypes, }: {
    column: nestedFields.NestedField<any, any>;
    nodeTypes: Dict<FormattedNodeDetails>;
    dataTypes: Dict<DataTypeDetails>;
}): nestedFields.NestedField<any, any>;
//# sourceMappingURL=data-type-utils.d.ts.map