import { noop } from 'lodash';
import { isDevMode } from './window';
const consoleHistory = [];
export const isNoConsole = () => {
    try {
        return !!process?.env?.NO_CONSOLE;
    }
    catch {
        return false;
    }
};
const fakeConsoleLog = (originalMethod) => (...args) => {
    consoleHistory.push(`${new Date().toISOString()} - ${originalMethod.name.toUpperCase()} -\n`);
    consoleHistory.push(...args);
    originalMethod.apply(window.console, args);
};
if (isDevMode()) {
    window.__PRINT_CONSOLE_HISTORY = () => {
        const history = consoleHistory
            .map(e => {
            try {
                return JSON.stringify(e, null, 4);
            }
            catch {
                return String(e);
            }
        })
            .join('\n\n-----------------------------------------------------------\n\n');
        consoleHistory.splice(0, consoleHistory.length);
        return history;
    };
}
export const xtremConsole = new Proxy(window.console, {
    get: (target, prop) => {
        try {
            if (isNoConsole() || !isDevMode()) {
                return noop;
            }
            return fakeConsoleLog(target[prop]);
        }
        catch (err) {
            return target[prop];
        }
    },
});
//# sourceMappingURL=console.js.map