import type { CellPosition, ColumnState, DateFilterModel, GridApi, NumberFilterModel, SetFilterModel, TabToNextCellParams, TextFilterModel } from '@ag-grid-community/core';
import type { Dict } from '@sage/xtrem-shared';
import type { EnumType } from 'json-to-graphql-query';
import type { PickProperties } from 'ts-essentials';
import type { OnTelemetryEventFunction } from '../../redux/state';
import type { CollectionValue } from '../../service/collection-data-service';
import type { Filter } from '../../service/filter-service';
import type { ValidationResult } from '../../service/screen-base-definition';
import type { AgGridColumnConfigWithScreenIdAndColDef, ColumnPanelColumnState, FilterValue } from './ag-grid-utility-types';
export type FilterModel = DateFilterModel | NumberFilterModel | TextFilterModel | SetFilterModel;
export declare const ROW_HEIGHT = 40;
export declare const getFilterValueFromAgGridFilterStatement: (filterBase: FilterModel & {
    filterById?: boolean;
}, filterKey: string) => FilterValue;
export declare function callGridMethod<M extends keyof PickProperties<GridApi, (...args: any[]) => any>>(gridApi: GridApi | undefined | null, method: M, ...args: ArgsType<GridApi[M]>): ReturnType<GridApi[M]> | undefined;
export declare function getSafeGridApiContext<M extends keyof PickProperties<GridApi, (...args: any[]) => any>, R>(cb: (arg: ReturnType<GridApi[M]> extends void ? undefined : ReturnType<GridApi[M]>) => R, gridApi: GridApi | undefined | null, method: M, ...args: ArgsType<GridApi[M]>): R | undefined;
export type FilterTypes = string | number | boolean | EnumType;
type ArgsType<T> = T extends (...args: infer A) => any ? A : never;
export declare const mapAgGridFilterToXtremFilters: (filterModel: Dict<any>) => (filterKey: any) => Filter<FilterTypes>;
export declare const tryToCommitPhantomRow: ({ api, screenId, value, elementId, }: {
    api: GridApi;
    screenId: string;
    value: CollectionValue;
    elementId: string;
}) => Promise<Dict<ValidationResult> | null>;
export declare const tabToNextCell: (screenId: string, elementId: string, value: () => CollectionValue, onTelemetryEvent?: OnTelemetryEventFunction) => (event: TabToNextCellParams) => CellPosition | null;
export declare const getFirstEditableColumn: (api: GridApi, data?: any, includeSelect?: boolean) => string | undefined;
export declare const getFilterModel: (api?: GridApi | null, groupByColumnField?: string) => any | undefined;
export declare const getAllUnselectedIds: (gridApi: GridApi) => string[];
export declare const getColumnStatesForColumnPanel: (screenId: string, columnDefinitions?: AgGridColumnConfigWithScreenIdAndColDef[], columnStates?: ColumnState[]) => ColumnPanelColumnState[];
export {};
//# sourceMappingURL=ag-grid-table-utils.d.ts.map