import type { MenuSeparatorType } from '../component/control-objects';
import type { DropdownActionItem, ErrorHandlerFunction } from '../component/field/traits';
import type { NestedCollectionItemAction, NestedCollectionItemActionGroup } from '../component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
import type { XtremActionPopoverItem } from '../component/ui/xtrem-action-popover';
import type { AccessBindings } from '../service/page-definition';
export type ActionType = 'pod-action' | 'pod-collection-action' | 'table-dropdown-action' | 'table-inline-action' | 'table-sidebar-header-dropdown-action' | 'table-sidebar-header-quick-action';
export interface CalculateActionMenuPropsWithSeparator {
    accessBindings: AccessBindings;
    actions?: Array<DropdownActionItem<any> | NestedCollectionItemAction<any> | MenuSeparatorType | NestedCollectionItemActionGroup<any>>;
    actionType: ActionType;
    screenId: string;
    onTriggerMenuItem: (context: {
        id?: string;
        uniqueId: string;
    }, eventHandler: (this: any, recordId: string, rowItem: any, level?: number, parentIds?: string[]) => void, errorHandler?: ErrorHandlerFunction<any>) => void;
    rowValue?: any;
    pendoId?: string;
}
export interface CalculateActionMenuProps {
    accessBindings: AccessBindings;
    actions?: Array<DropdownActionItem<any> | NestedCollectionItemAction<any>>;
    onTriggerMenuItem: (context: {
        id?: string;
        uniqueId: string;
    }, isDisabled: boolean, eventHandler: (this: any, recordId: string, rowItem: any, level?: number, parentIds?: string[]) => void, errorHandler?: ErrorHandlerFunction<any>) => void;
    rowValue?: any;
    screenId: string;
}
export declare function calculateActionMenu(args: CalculateActionMenuPropsWithSeparator): Array<XtremActionPopoverItem>;
//# sourceMappingURL=action-menu-utils.d.ts.map