import type { Dict } from '@sage/xtrem-shared';
import type { BaseControlObject, ComponentProperties } from '../component/base-control-object';
import type { ReferenceProperties } from '../component/field/reference/reference-types';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import { ReadonlyFieldControlObject } from '../component/readonly-field-control-object';
import type { ComponentKey, FieldDecoratorProps } from '../component/types';
import type { FilterManagerField } from '../component/ui/filter/filter-manager';
import type { ScreenBase } from '../service/screen-base';
import type { ValidationResult } from '../service/screen-base-definition';
import { GraphQLTypes } from '../types';
import type { FormattedNodeDetails } from '../service/metadata-types';
/**
 * This function will retrieve an elementId for nestedFields.
 * @param field
 */
export declare function getNestedFieldElementId(args: undefined): null;
export declare function getNestedFieldElementId(args?: NestedField<ScreenBase, NestedFieldTypes> | FilterManagerField): string;
export declare function getNestedFieldElementId(args?: NestedField<ScreenBase, NestedFieldTypes> | FilterManagerField): string;
export declare const filterFields: (controlObjects: Dict<BaseControlObject<any, any>>) => Dict<ReadonlyFieldControlObject<any, any, any>>;
export declare function getValueTypes(controlObjects: Dict<BaseControlObject<any, any>>, uiComponentProperties: Dict<FieldDecoratorProps<any>>): Dict<ReadonlyFieldControlObject<any, any, any>>;
export declare const setDefaultProperties: <T extends ComponentProperties<any>>(decoratorProperties: T, defaultProperties: Partial<T>, controlObjectType?: ComponentKey) => T;
export declare const getContainerChildFields: (screen: ScreenBase, controlObjects: BaseControlObject<any, any>[], elementId: string) => BaseControlObject<any, any>[];
export declare const getAllParents: (screen: ScreenBase, fields: BaseControlObject<any, any>[]) => BaseControlObject<any, any>[];
export declare const getPropertyScalarType: (nodeTypes: Dict<FormattedNodeDetails>, propertyType: string, fieldType: NestedFieldTypes, valueField?: ReferenceProperties<any>['valueField']) => GraphQLTypes | null;
export declare const handleChange: <V>(bind: string, value: V, setFieldValue: (bind: string, value: V) => Promise<void>, validate?: (bind: string, value: V) => Promise<ValidationResult[] | undefined>, onChange?: (newValue: V) => void) => void;
export declare const normalizeUnderscoreBind: (bind: string) => string;
export declare const findColumnDefinitionByBind: <T extends NestedField<ScreenBase<any, any>, NestedFieldTypes, any, any> | FilterManagerField>(columns: T[], bind: string) => T | undefined;
export declare const filterColumnDefinitionByBind: <T extends NestedField<ScreenBase<any, any>, NestedFieldTypes, any, any> | FilterManagerField>(columns: T[], bind: string) => T[];
//# sourceMappingURL=abstract-fields-utils.d.ts.map