import type { ClientNode } from '@sage/xtrem-client';
import type { Dict } from '@sage/xtrem-shared';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { ReadonlyFieldProperties } from '../component/readonly-field-control-object';
import type { CollectionItem, ComponentKey, ControlObjectInstance } from '../component/types';
import type { FormattedNodeDetails } from './metadata-types';
import type { PageDefinition } from './page-definition';
import type { XtremUiPlugin } from './plugin-service';
import type { ScreenBase } from './screen-base';
/**
 * Formats a single field into a suitable format based on its server-side GraphQL type or the corresponding control
 * object
 *
 * @param screenId
 * @param elementId
 * @param nodeTypes
 * @param fieldType
 * @param fieldProperties
 * @param value
 * @param parentNode
 */
export declare const formatValue: ({ pageDefinition, elementId, fieldProperties, fieldType, nodeTypes, parentNode, plugins, rowValue, screenId, value, }: {
    pageDefinition?: PageDefinition;
    elementId: string;
    fieldProperties: ReadonlyFieldProperties;
    fieldType: ComponentKey;
    nodeTypes: Dict<FormattedNodeDetails>;
    parentNode?: string;
    plugins: Dict<XtremUiPlugin>;
    rowValue?: any;
    screenId: string;
    value?: any;
}) => any;
export interface FormatCollectionItemArgs<T extends ClientNode = any> {
    screenId: string;
    nodeTypes: Dict<FormattedNodeDetails>;
    collectionItem: CollectionItem;
    plugins?: Dict<XtremUiPlugin>;
    columnsDefinitions: NestedField<ScreenBase, NestedFieldTypes, T>[];
    parentNode?: string;
    contextRow?: any;
}
/**
 * Format all values of a nested collection item into client-side suitable format based on various rules depending on
 * the server-side node GraphQL types and the control object types.
 * @param screenId
 * @param nodeTypes
 * @param collectionItem
 * @param columnsDefinitions
 * @param parentNode
 */
export declare const formatCollectionItem: <T extends ClientNode = any>({ screenId, nodeTypes, collectionItem, plugins, columnsDefinitions, parentNode, contextRow, }: FormatCollectionItemArgs<T>) => T;
/**
 * Format all values of a screen into client-side suitable format based on various rules depending on the server-side
 * node GraphQL types and the control object types.
 *
 * If the `onlyElementIds` parameter is supplied, it will only format those values which are provided in this parameter.
 *
 * @param screenId
 * @param controlObjects
 * @param uiComponentProperties
 * @param nodeTypes
 * @param values
 * @param parentNode
 */
export declare const formatScreenValues: ({ pageDefinition, screenId, controlObjects, plugins, nodeTypes, values, parentNode, onlyElementIds, }: {
    pageDefinition?: PageDefinition;
    screenId: string;
    controlObjects: Dict<ControlObjectInstance<any>>;
    plugins: Dict<XtremUiPlugin>;
    nodeTypes: Dict<FormattedNodeDetails>;
    values: Dict<any>;
    parentNode?: string;
    onlyElementIds?: string[];
}) => Dict<any>;
//# sourceMappingURL=value-formatter-service.d.ts.map