import type { ToastProps } from 'carbon-react/esm/components/toast';
import type { ContainerValidationResult } from './dispatch-service';
import type { PageMetadata } from './page-metadata';
import * as React from 'react';
export type ToastType = ToastProps['variant'];
export interface ToastOptions {
    language?: 'markdown' | 'jsx';
    timeout?: number;
    type?: ToastType;
}
export interface Toast {
    content: string | React.ReactNode;
    isDismissed: boolean;
    id: number;
    language?: ToastOptions['language'];
    timeout: number;
    type: ToastType;
}
export declare const PERMANENT_TOAST: number;
export declare const showToast: (content: Toast['content'], options?: ToastOptions) => void;
export declare const showContainerValidationToast: (pageMetadata: PageMetadata, result: ContainerValidationResult) => void;
export declare const removeToasts: () => void;
//# sourceMappingURL=toast-service.d.ts.map