export const TABLE_VIEW_STORAGE_KEY = 'TableViews';
export const getStoredTableViewsByScreen = (username, screenId) => {
    if (!localStorage) {
        return Promise.reject();
    }
    try {
        const serialized = localStorage.getItem(TABLE_VIEW_STORAGE_KEY);
        if (serialized) {
            const localViews = JSON.parse(serialized);
            const userViews = localViews?.[username];
            const screenViews = userViews?.[screenId];
            return screenViews ? Promise.resolve(screenViews) : Promise.reject();
        }
        return Promise.reject();
    }
    catch {
        return Promise.reject();
    }
};
export const getStoredTableViewsByElement = (username, screenId, elementId) => {
    if (!localStorage) {
        return Promise.reject();
    }
    try {
        const serialized = localStorage.getItem(TABLE_VIEW_STORAGE_KEY);
        if (serialized) {
            const localViews = JSON.parse(serialized);
            const userViews = localViews?.[username];
            const screenViews = userViews?.[screenId];
            const elementViews = screenViews?.[elementId];
            return elementViews ? Promise.resolve(elementViews) : Promise.reject();
        }
        return Promise.reject();
    }
    catch {
        return Promise.reject();
    }
};
export const setStoredTableViewsByScreen = (username, screenId, tableViews) => {
    if (!localStorage) {
        return Promise.reject();
    }
    try {
        let serialized = localStorage.getItem(TABLE_VIEW_STORAGE_KEY);
        if (!serialized) {
            serialized = JSON.stringify({ [username]: {} });
        }
        const localViews = JSON.parse(serialized);
        const userViews = localViews?.[username];
        if (userViews) {
            userViews[screenId] = tableViews;
            const reserialized = JSON.stringify(localViews);
            localStorage.setItem(TABLE_VIEW_STORAGE_KEY, reserialized);
            return Promise.resolve(userViews[screenId]);
        }
        return Promise.reject();
    }
    catch {
        return Promise.reject();
    }
};
export const setStoredTableViewsByElement = (username, screenId, elementId, tableViews) => {
    if (!localStorage) {
        return Promise.reject();
    }
    try {
        let serialized = localStorage.getItem(TABLE_VIEW_STORAGE_KEY);
        if (!serialized) {
            serialized = JSON.stringify({ [username]: { [screenId]: {} } });
        }
        const localViews = JSON.parse(serialized);
        const userViews = localViews?.[username];
        const screenViews = userViews?.[screenId];
        if (screenViews) {
            screenViews[elementId] = tableViews;
            const reserialized = JSON.stringify(localViews);
            localStorage.setItem(TABLE_VIEW_STORAGE_KEY, reserialized);
            return Promise.resolve(userViews[screenId]);
        }
        return Promise.reject();
    }
    catch {
        return Promise.reject();
    }
};
export const clearStoredTableViewsByElement = (username, screenId, elementId) => {
    if (!localStorage) {
        return Promise.reject();
    }
    try {
        const serialized = localStorage.getItem(TABLE_VIEW_STORAGE_KEY);
        if (serialized) {
            const localViews = JSON.parse(serialized);
            const userViews = localViews?.[username];
            const screenViews = userViews?.[screenId];
            if (screenViews) {
                screenViews[elementId] = {
                    $current: {
                        canDelete: false,
                        canUpdate: false,
                        name: '$current',
                        level: [{}],
                        visibility: 'private',
                    },
                };
                const reserialized = JSON.stringify(localViews);
                localStorage.setItem(TABLE_VIEW_STORAGE_KEY, reserialized);
                return Promise.resolve();
            }
            return Promise.reject();
        }
        return Promise.reject();
    }
    catch {
        return Promise.reject();
    }
};
//# sourceMappingURL=table-view-storage-service.js.map