import type { Dict } from '@sage/xtrem-shared';
export type PrimitiveType = string | number | boolean | null;
export interface Storage {
    set: (key: string, value: string | number | boolean) => void;
    get: (key: string) => PrimitiveType;
    getAll: () => Dict<PrimitiveType>;
    remove: (key: string) => void;
}
/** Add a single entry from the storage */
export declare const set: (key: string, value: string | number | boolean) => void;
/** Get a single entry from the storage */
export declare const get: (key: string) => PrimitiveType;
/** Get all entries from the storage as a dictionary */
export declare const getAll: () => Dict<PrimitiveType>;
/** Removes a single entry from the storage */
export declare const remove: (key: string) => void;
//# sourceMappingURL=storage-service.d.ts.map