import type { ClientNode } from '@sage/xtrem-client';
import type { NavigationPanelState, TableView } from '../redux/state';
import type { Dict } from '@sage/xtrem-shared';
import type { AccessBindings } from './page-definition';
import type { PageMetadata } from './page-metadata';
import type { ScreenBase } from './screen-base';
export interface ValidationResult {
    columnId?: string;
    elementId: string;
    level?: number;
    message: string;
    messagePrefix?: string;
    recordId?: string;
    screenId: string;
    validationRule: string;
}
export interface ScreenBaseDefinition<T extends ClientNode = any> {
    accessBindings: AccessBindings;
    dialogId?: number;
    dirtyStates: Dict<boolean>;
    errors: Dict<ValidationResult[]>;
    internalErrors: Dict<ValidationResult>;
    metadata: PageMetadata;
    navigationPanel?: NavigationPanelState<T>;
    selectedRecordId?: string | null;
    tableViews: Dict<Dict<TableView>>;
    type: 'page' | 'sticker';
    values: Dict<any | null>;
    onFinish?: (values: any) => void;
}
export declare const getScreenElement: (screenDefinition: ScreenBaseDefinition) => ScreenBase;
//# sourceMappingURL=screen-base-definition.d.ts.map