import type { QueryParameters } from '../utils/types';
/** Router API. It encapsulates function that enable developers to navigate to various pages and open records programmatically. */
export interface IRouter {
    /** Navigates to another page, query parameters can be sent to the page that is being opened. */
    goTo: (path: string, queryParameters?: QueryParameters, skipDirtyCheck?: boolean) => void;
    /** Navigates to an external link in a new tab. */
    goToExternal: (link: string) => void;
    /**
     * Refreshes the current page, it restores the page to it's original state including field values and all component properties.
     * If the page is bound to any record, the value is refetched from the server.
     * It triggers the `onLoad` lifecycle hooks in page and page extension decorators.
     */
    refresh: (skipDirtyCheck?: boolean) => Promise<void>;
    /**
     * Clears all field values and resets all component properties. It triggers the `onLoad` lifecycle hooks in page and page extension decorators.
     */
    emptyPage: (skipDirtyCheck?: boolean) => Promise<void>;
    /**
     * Close the current record and navigates to the full width nav panel.
     */
    closeRecord: (skipDirtyCheck?: boolean) => Promise<void>;
    /**
     * Selects a record of the current page. The action is identical to when the the user selects a record from the navigation panel.
     */
    selectRecord: (_id: number | string, skipDirtyCheck?: boolean) => Promise<void>;
    /**
     * Selects the first record from the navigation panel
     */
    firstRecord: (skipDirtyCheck?: boolean) => Promise<void>;
    /**
     * Selects the next record from the navigation panel. This action can only be used if a navigation panel is defined for the page.
     */
    nextRecord: (skipDirtyCheck?: boolean) => Promise<void>;
    /**
     * Selects the previous record from the navigation panel. This action can only be used if a navigation panel is defined for the page.
     */
    previousRecord: (skipDirtyCheck?: boolean) => Promise<void>;
    /**
     *  Determines whether there is a next record on the navigation panel. This action can only be used if a navigation panel is defined for the page.
     */
    hasNextRecord: () => Promise<boolean>;
    /**
     * Determines whether there is a previous record on the navigation panel. This action can only be used if a navigation panel is defined for the page.
     */
    hasPreviousRecord: () => Promise<boolean>;
    hardRefresh: () => Promise<void>;
    goHome: (skipDirtyCheck?: boolean) => Promise<void>;
}
export declare class Router implements IRouter {
    private readonly screenId;
    constructor(screenId: string);
    private isScreenDirty;
    private wrapNavigationMethod;
    goTo(path: string, queryParameters?: QueryParameters, skipDirtyCheck?: boolean): Promise<void>;
    goToExternal(link: string): void;
    refresh(skipDirtyCheck?: boolean): Promise<void>;
    emptyPage(skipDirtyCheck?: boolean): Promise<void>;
    closeRecord(skipDirtyCheck?: boolean): Promise<void>;
    selectRecord(recordId: number | string, skipDirtyCheck?: boolean): Promise<void>;
    firstRecord(skipDirtyCheck?: boolean): Promise<void>;
    nextRecord(skipDirtyCheck?: boolean): Promise<void>;
    previousRecord(skipDirtyCheck?: boolean): Promise<void>;
    hasPreviousRecord(): Promise<boolean>;
    hasNextRecord(): Promise<boolean>;
    hardRefresh(): Promise<void>;
    goHome(skipDirtyCheck?: boolean): Promise<void>;
}
export declare const getRouter: (screenId: string) => Router;
//# sourceMappingURL=router.d.ts.map