import type { Dict, NodeDetails, Property } from '@sage/xtrem-shared';
import type { RawNodeDetails } from './metadata-types';
export { NodeDetails };
export declare const fetchNodeNames: (onlyPublishedNodes?: boolean) => Promise<Dict<string>>;
export interface AttachmentInformation {
    attachmentAssociationNode: string;
    attachmentFileNode: string;
}
export declare const fetchNodeDetails: ({ locale, nodeName, getCollections, }: {
    locale: string;
    nodeName: string;
    getCollections?: boolean;
}) => Promise<Dict<NodeDetails>>;
export declare const fetchNodePackageName: (nodeName: string) => Promise<string>;
export declare const mapNodeDetailsToTreeProperty: (parent: Property, nodeDetails: NodeDetails[]) => Property[];
export declare const rawNodeDetailsToTreeProperty: (parent: Property, rawNodeDetails: RawNodeDetails[], getCollections?: boolean) => Property[];
//# sourceMappingURL=node-information-service.d.ts.map