import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
import type { OptionsMenuItem, OptionsMenuItemType, OptionsMenuType, RuntimePageNavigationPanel } from '../component/container/page/page-types';
import type { InternalTableProperties, TableDecoratorProperties } from '../component/field/table/table-component-types';
import type { OrderByType, PartialCollectionValue } from '../component/types';
import type { ApplicationContext } from '../integration';
import type { NodePropertyType } from '../types';
import { CollectionValue } from './collection-data-service';
import type { PageDefinition } from './page-definition';
import type { DataTypeDetails, FormattedNodeDetails } from './metadata-types';
export declare function createMySelectedDataOptionItem(pageDefinition: PageDefinition): OptionsMenuItem;
export declare const resolveNavigationPanelOptionFilter: (pageDefinition: PageDefinition) => (optionItem?: OptionsMenuItem) => OptionsMenuItem | undefined;
export declare const resolveOptionsMenu: (pageDefinition: PageDefinition, optionsMenu: OptionsMenuType<any> | undefined, applicationContext?: ApplicationContext) => Promise<OptionsMenuItemType[]>;
export declare const getMergedOptionMenu: (pageDefinition: PageDefinition, navigationPanel: RuntimePageNavigationPanel<any>, applicationContext?: ApplicationContext) => Promise<OptionsMenuItemType[]>;
export declare const getInitialOptionMenuItem: (pageDefinition: PageDefinition, navigationTableProperties: InternalTableProperties) => OptionsMenuItem | undefined;
export declare const onNavigationPanelRowClick: (pageDefinition: PageDefinition, navigationPanel: RuntimePageNavigationPanel<any>, path?: string) => (recordId: string, rowItem: any, isModifierKeyPushed?: boolean) => void;
export declare const createNavigationTableProperties: (screenId: string, pageNode: NodePropertyType, pageDefinition: PageDefinition, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, path?: string, applicationContext?: ApplicationContext) => Promise<InternalTableProperties>;
export declare const createNavigationPanelValue: (screenId: string, navigationPanelTableProperties: TableDecoratorProperties, initialValues: PartialCollectionValue<any>[], nodeTypes?: Dict<FormattedNodeDetails>, locale?: LocalizeLocale, activeOptionsMenuItem?: OptionsMenuItem, orderBy?: OrderByType) => CollectionValue;
//# sourceMappingURL=navigation-panel-service.d.ts.map