import type { ClientNode, Filter, FilterOperatorComparable, FilterOperatorEquality, FilterOperatorInclusion, Logical, Quantifiers } from '@sage/xtrem-client';
import type { Dict } from '@sage/xtrem-shared';
import type { CollectionValueFieldProperties, MultiReferenceProperties, ReferenceProperties } from '../../component/control-objects';
import type { PropertyValueType } from '../../component/field/reference/reference-types';
import { type NestedField, type NestedFieldTypes } from '../../component/nested-fields';
import type { ReadonlyFieldControlObject, ReadonlyFieldProperties } from '../../component/readonly-field-control-object';
import type { OrderByType } from '../../component/types';
import type { CardDefinition } from '../../component/ui/card/card-component';
import type { NodePropertyType } from '../../types';
import { CollectionFieldTypes } from '../collection-data-types';
import type { CollectionQuery, ExecutableQuery, GraphQLFilter, NodeCollection, NonArrayGraphQLFilter, QueryArguments, QueryBuilderOptions, QueryEnumWrapper, QueryFilterOperator, QueryProperty, QueryWrapper, TotalCountQuery } from '../graphql-utils';
import type { FormattedNodeDetails } from '../metadata-types';
import type { Page } from '../page';
import type { PageMetadata } from '../page-metadata';
import type { ScreenBase } from '../screen-base';
import type { ScreenBaseDefinition } from '../screen-base-definition';
export declare const RESTRICTED_COLUMN_PREFIX = "__restricted_";
export declare const RESTRICTED_COLUMN_ALL_PREFIX = "__all_";
export type QuantifierType = keyof Quantifiers;
export declare const quantifiers: QuantifierType[];
export * from './field-query-builder';
export type ExtendedTitleProps = Array<{
    [key: string]: {
        __aliasFor: string;
        [key: string]: boolean | string;
    };
}>;
export type FilterReservedWord = keyof FilterOperatorComparable<any> | keyof FilterOperatorEquality<any> | keyof FilterOperatorInclusion<any> | keyof Logical<any> | keyof Quantifiers | keyof QueryFilterOperator;
export declare const filterReservedWords: ("_and" | "_or" | "_not" | "_mod" | "_regex" | "_options" | "_gt" | "_gte" | "_lt" | "_lte" | "_eq" | "_ne" | "_in" | "_nin" | "_contains" | "_containsRange" | "_containedBy" | "start" | "end" | "_atLeast" | "_atMost" | "_every" | "_none")[];
export declare const DATA_TYPE_FRAGMENT: {
    name: boolean;
    type: boolean;
    title: boolean;
    node: boolean;
    precision: boolean;
    scale: boolean;
    maxLength: boolean;
    value: {
        bind: boolean;
        title: boolean;
        type: boolean;
    };
    helperText: {
        bind: boolean;
        title: boolean;
        type: boolean;
    };
    imageField: {
        bind: boolean;
        title: boolean;
        type: boolean;
    };
    columns: {
        bind: boolean;
        title: boolean;
        type: boolean;
    };
    values: {
        value: boolean;
        title: boolean;
    };
    tunnelPage: boolean;
    tunnelPageId: {
        bind: boolean;
        title: boolean;
        type: boolean;
    };
};
export declare function getNodeDetailsPropertiesFragment(): any;
export declare function getNodeDetailsFragment(): any;
export declare function getNodeCustomDetailsFragment(): any;
export declare const getPlatformStringLiteralsSchemaFragment: () => ExecutableQuery;
export declare function getBindAndSelectorFromDeepBinding(bind: string, contextNode: string, nodeTypes: Dict<FormattedNodeDetails>, alias?: string): {
    valuePath: string;
    jsonSelector?: string;
};
export declare const addTotalCountTransform: (filter: Filter<any>, initial: CollectionQuery['edges']['node']) => Filter<any>;
export declare const addReferenceIdsAssign: (filter: Filter<any>, node?: NodePropertyType, nodeTypes?: Dict<FormattedNodeDetails>) => Filter<any>;
export declare const parseFilterEnumFields: (source: NonArrayGraphQLFilter) => GraphQLFilter;
export declare const convertFilterDecoratorToGraphQLFilter: (screenDefinition: ScreenBaseDefinition, filter?: GraphQLFilter | ((this: Page) => GraphQLFilter), recordContext?: Dict<any>) => GraphQLFilter | undefined;
export declare const queryBuilder: (node: NodePropertyType, options: QueryBuilderOptions) => NodeCollection;
export declare const getUsedEnums: (pageMetadata: PageMetadata, knownEnumDefinitions: string[]) => string[];
export declare const buildEnumQuery: (enumName: string) => QueryEnumWrapper;
export declare const getUsedNodes: (pageMetadata: PageMetadata, knownTypeDefinitions?: string[], rootNode?: string) => string[];
export declare const buildTypeQuery: (nodeNames: string[], knownTypes: string[], depth?: number) => QueryEnumWrapper;
export declare const getRequestableFieldIds: (fieldControlObjects: Dict<ReadonlyFieldControlObject<any, any, any>>, screenDefinition: ScreenBaseDefinition) => string[];
export declare const buildEnumQueries: (enums: string[]) => QueryEnumWrapper;
export declare const buildTableTotalCountQuery: ({ filter }: {
    filter: string;
}) => TotalCountQuery;
export declare const buildFieldQuery: (rootNode: NodePropertyType, fieldControlObject: ReadonlyFieldControlObject<any, any, any>, screenDefinition: ScreenBaseDefinition, fieldProperties: ReadonlyFieldProperties, elementId: string, recordId: string, nodeTypes: Dict<FormattedNodeDetails>) => NodeCollection;
export declare const buildRootNodeQuery: (rootNode: NodePropertyType, fieldControlObjects: Dict<ReadonlyFieldControlObject<any, any, any>>, screenDefinition: ScreenBaseDefinition, _id: string, alias?: string, nodeTypes?: Dict<FormattedNodeDetails>, isDuplicate?: boolean) => QueryWrapper<any>;
export declare const getFilterAsString: (filters: (GraphQLFilter | (() => GraphQLFilter) | undefined)[], screenDefinition: ScreenBaseDefinition, recordContext?: Dict<any>) => string | undefined;
export declare const mergeFilters: (filters: (GraphQLFilter | (() => GraphQLFilter) | undefined)[], screenDefinition: ScreenBaseDefinition, recordContext?: Dict<any>) => GraphQLFilter;
export declare const applyDeepNestedKey: (elementId: string, fieldDetails: any, addAlias?: boolean, bind?: PropertyValueType, parentNode?: NodePropertyType, nodeTypes?: Dict<FormattedNodeDetails>) => any;
/**
 * Inspects the filter object, and prepare it for server side consumption.
 * It remaps id field names to match current server inconsistencies and creates nested sorting conditions for reference
 * fields.
 * @param orderBy
 */
export declare const createOrderByQueryArgument: (orderBy: OrderByType) => string;
export declare const getAggregationValues: (aggregations: object) => any;
export declare const nestedFieldsToQueryProperties: ({ screenDefinition, nestedFields, node, nodeTypes, }: {
    screenDefinition: ScreenBaseDefinition;
    nestedFields: NestedField<Page, NestedFieldTypes>[];
    nodeTypes?: Dict<FormattedNodeDetails>;
    node?: NodePropertyType;
}) => QueryProperty[];
export declare const getNestedFieldsQuery: ({ screenDefinition, nestedFields, queryArguments, alias, wrapNodeWithEdges, node, nodeTypes, }: {
    screenDefinition: ScreenBaseDefinition;
    nestedFields: NestedField<Page, NestedFieldTypes>[];
    nodeTypes?: Dict<FormattedNodeDetails>;
    node?: NodePropertyType;
    queryArguments?: QueryArguments;
    alias?: string;
    wrapNodeWithEdges?: boolean;
}) => NodeCollection;
export declare const parseQueryArguments: (inputArguments: QueryArguments) => QueryArguments;
export declare const getDirtyNestedValues: ({ screenDefinition, elementId, recordId, level, }: {
    screenDefinition: ScreenBaseDefinition;
    elementId: string;
    recordId?: string;
    level?: number;
}) => Dict<any>;
export declare const buildRowDefaultQuery: ({ screenDefinition, elementId, isNewRow, alias, recordId, data, nodeTypes, }: {
    screenDefinition: ScreenBaseDefinition;
    elementId: string;
    isNewRow?: boolean;
    alias?: string;
    recordId?: string;
    data?: any;
    nodeTypes: Dict<FormattedNodeDetails>;
}) => QueryWrapper<any>;
export declare const buildNestedDefaultsQuery: ({ screenDefinition, elementId, isNewRow, alias, recordId, level, data, nodeTypes, }: {
    screenDefinition: ScreenBaseDefinition;
    elementId: string;
    isNewRow?: boolean;
    alias?: string;
    recordId?: string;
    level?: number;
    data?: any;
    nodeTypes: Dict<FormattedNodeDetails>;
}) => QueryWrapper<any>;
/**
 * Builds a query to request default values from the server.
 * If a list of fields is not provided as the last argument, the function checks the screen definition and requests values for the non-dirty fields.
 */
export declare const buildDefaultsQuery: ({ screenDefinition, alias, requestedFieldIds, clean, additionalData, sendNonDirtyFields, node, nodeTypes, }: {
    screenDefinition: ScreenBaseDefinition;
    alias?: string;
    requestedFieldIds?: string[];
    clean?: boolean;
    additionalData?: Dict<any>;
    sendNonDirtyFields?: boolean;
    nodeTypes?: Dict<FormattedNodeDetails>;
    node?: NodePropertyType;
}) => QueryWrapper<any>;
export declare const getNavigationPanelOrderByDefinition: (listItem: CardDefinition, explicitOrderBy?: OrderByType) => OrderByType;
export declare const buildSearchBoxFilterForNestedFields: <T extends ClientNode = any>(nestedFields: NestedField<ScreenBase, NestedFieldTypes, T>[], nodeTypes: Dict<FormattedNodeDetails>, filterText: string, locale?: string, node?: NodePropertyType) => GraphQLFilter<T>[];
export declare const buildSearchBoxFilter: <T extends ClientNode = any>(fieldProperties: ReferenceProperties<ScreenBase, T> | MultiReferenceProperties<ScreenBase, T> | CollectionValueFieldProperties<ScreenBase, T>, nodeTypes: Dict<FormattedNodeDetails>, locale?: string, collectionFieldType?: CollectionFieldTypes, searchBoxText?: string, exactMatch?: boolean, isArray?: boolean) => GraphQLFilter<T> | undefined;
//# sourceMappingURL=index.d.ts.map