import { Graph } from '@sage/xtrem-client';
import type { Dict } from '@sage/xtrem-shared';
import type { OmitProperties } from 'ts-essentials';
import type { ComponentKey } from '../component/types';
import type { ScreenBase } from './screen-base';
export declare const nonSavableFieldType: ComponentKey[];
interface DeletionArguments<K> {
    nodeName?: K;
    _id?: string | number;
}
interface DuplicationArguments<K> {
    nodeName?: K;
    _id?: string | number;
    values?: Dict<any>;
}
interface CreationArguments<K> extends DeletionArguments<K> {
    values?: Dict<any>;
    fieldsToReturn?: string[];
}
type ModificationArguments<K> = CreationArguments<K>;
type QueryOrReadExtractor<T> = {
    [K in keyof T]: K extends 'query' | 'read' | 'aggregate' ? T[K] : never;
};
type QueryOrRead<T> = OmitProperties<QueryOrReadExtractor<T>, never>;
export declare class ReadOnlyGraphQLApi<TGraphqlApi> {
    readonly graph: Graph<TGraphqlApi>;
    constructor();
    node<K extends keyof TGraphqlApi>(nodeName: K): QueryOrRead<TGraphqlApi[K]>;
    raw(query: string, isMetaDataQuery?: boolean): Promise<any>;
}
export declare class GraphQLApi<TGraphqlApi> {
    protected readonly screenBase: ScreenBase;
    readonly graph: Graph<TGraphqlApi>;
    constructor(screenBase: ScreenBase);
    private getQueryParameters;
    node<K extends keyof TGraphqlApi>(nodeName: K): TGraphqlApi[K];
    /**
     * Executes a raw GraphQL query string against the server endpoint.
     * @param query the query string
     * @param skipErrorProcessing if this property is set to true, the framework will not try to intercept the error and
     * @returns
     */
    raw(query: string, skipErrorProcessing?: boolean, isMetaDataQuery?: boolean): Promise<any>;
    private nodeName;
    private applyUpdateToValue;
    private getNonTransientFieldsQuery;
    create<K extends keyof TGraphqlApi>(args?: CreationArguments<K>): Promise<void>;
    update<K extends keyof TGraphqlApi>(args?: ModificationArguments<K>, skipUpdate?: boolean): Promise<void>;
    delete<K extends keyof TGraphqlApi>(args?: DeletionArguments<K>): Promise<void>;
    duplicate<K extends keyof TGraphqlApi>(args?: DuplicationArguments<K>): Promise<string | null>;
}
export {};
//# sourceMappingURL=graphql-api.d.ts.map