import * as React from 'react';
import { connect } from 'react-redux';
import { addOptionsAndLocalizationToProps } from '../utils/transformers';
import { FieldKey } from '../component/types';
import { AsyncSelectComponent } from '../component/field/select/async-select-component';
import { AsyncDropdownListComponent } from '../component/field/dropdown-list/async-dropdown-list-component';
import { AsyncRadioComponent } from '../component/field/radio/async-radio-component';
import { AsyncMultiDropdownComponent } from '../component/field/multi-dropdown/async-multi-dropdown-component';
export function SelectLikeFieldWrapper(props) {
    switch (props.fieldType) {
        case FieldKey.Select:
            return React.createElement(AsyncSelectComponent, { ...props });
        case FieldKey.DropdownList:
            return React.createElement(AsyncDropdownListComponent, { ...props });
        case FieldKey.Radio:
            return React.createElement(AsyncRadioComponent, { ...props });
        case FieldKey.MultiDropdown:
            return React.createElement(AsyncMultiDropdownComponent, { ...props });
        default:
            return (React.createElement("div", null,
                "Unsupported type:",
                props.fieldType));
    }
}
const mapStateToProps = (state, props) => {
    return addOptionsAndLocalizationToProps(state, props);
};
export const ConnectedSelectLikeFieldWrapper = connect(mapStateToProps)(SelectLikeFieldWrapper);
//# sourceMappingURL=select-like-field-wrapper.js.map