/**
 * @packageDocumentation
 * @module root
 * */
import type { AccessStatus } from '@sage/xtrem-shared';
import * as React from 'react';
import type { BaseControlObject } from '../component/base-control-object';
import type { FieldWrapperExternalProps } from '../component/field/field-base-component-types';
import type { ResponsiveTypes } from '../redux/state';
export interface FieldWrapperProps extends FieldWrapperExternalProps {
    fieldController: BaseControlObject<any, any>;
    browserIs?: ResponsiveTypes;
    isHidden?: boolean;
    accessRule?: AccessStatus;
    onFocus: (screenId: string, elementId: string, row: string, nestedField: string) => void;
    fixedHeight?: number;
}
/**
 * Main field type router. Depending on the field type, it renders the corresponding component to the DOM
 */
export declare class FieldWrapper extends React.Component<FieldWrapperProps> {
    /** A field is hidden if it is hidden by its `isHidden` decorator property or if the field is unavailable for
     * the current user based on the access rights computation.
     **/
    private readonly isHidden;
    private readonly renderField;
    render(): React.ReactNode;
}
declare const _default: import("react-redux").ConnectedComponent<typeof FieldWrapper, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<FieldWrapper> | undefined;
    item?: import("..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    fixedHeight?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default _default;
//# sourceMappingURL=field-wrapper.d.ts.map