import { ActionType } from '../action-types';
import { combineReducers } from 'redux';
export const isOpen = (state = false, action) => {
    if (action.type === ActionType.SetWidgetEditorOpen) {
        return action.value.isOpen;
    }
    return state;
};
export const isDirty = (state = false, action) => {
    if (action.type === ActionType.UpdateUserWidgetDefinition) {
        // TODO: Revise this logic when we load previously created widgets for editing.
        return true;
    }
    if (action.type === ActionType.SetWidgetEditorOpen) {
        // Reset the dirty state when the dialog is being closed
        return false;
    }
    return state;
};
export const widgetDefinition = (state = {}, action) => {
    if (action.type === ActionType.UpdateUserWidgetDefinition) {
        return action.value.widget;
    }
    if (action.type === ActionType.SetWidgetEditorOpen && !action.value.isOpen) {
        // Reset the value of the document when the editor is closed
        return {};
    }
    if (action.type === ActionType.SetWidgetEditorOpen && action.value.widgetDefinition) {
        // Sets the widget definition
        return action.value.widgetDefinition;
    }
    return state;
};
export const widgetId = (state = '', action) => {
    if (action.type === ActionType.SetWidgetEditorOpen && !action.value.isOpen) {
        return '';
    }
    if (action.type === ActionType.SetWidgetEditorOpen && action.value.widgetId) {
        return action.value.widgetId;
    }
    return state;
};
export const widgetEditor = combineReducers({
    isDirty,
    isOpen,
    widgetDefinition,
    widgetId,
});
//# sourceMappingURL=widget-editor.js.map