import { ActionType } from '../action-types';
import { snakeCase } from 'lodash';
import { getArtifactDescription } from '../../utils/transformers';
const extractEnumTranslations = (enumValues) => Object.keys(enumValues).reduce((prevValue, key) => {
    const enumDefinition = enumValues[key];
    const { vendor, package: pck, name } = getArtifactDescription(enumDefinition.name);
    enumDefinition.values.forEach((memberName, index) => {
        const translationKey = `${vendor}/${pck}/enums__${snakeCase(name)}__${memberName}`;
        if (enumDefinition.translations?.[index]) {
            prevValue[translationKey] = enumDefinition.translations[index];
        }
    });
    return prevValue;
}, {});
export const translations = (state = {}, action) => {
    if (action.type === ActionType.AddTranslations) {
        return { ...state, [action.value.locale]: { ...state[action.value.locale], ...action.value.literals } };
    }
    if (action.type === ActionType.AddSchemaInfo) {
        return {
            ...state,
            [action.value.locale]: {
                ...state[action.value.locale],
                ...extractEnumTranslations(action.value.enumTypes),
            },
        };
    }
    if (action.type === ActionType.FinishScreenLoading) {
        return {
            ...state,
            [action.value.locale]: {
                ...state[action.value.locale],
                ...extractEnumTranslations(action.value.enumTypes),
            },
        };
    }
    if (action.type === ActionType.AddEnumType) {
        return {
            ...state,
            [action.value.locale]: {
                ...state[action.value.locale],
                ...extractEnumTranslations(action.value.enums),
            },
        };
    }
    return state;
};
//# sourceMappingURL=translations.js.map