import produce from 'immer';
import { xtremConsole } from '../../utils/console';
import { ActionType } from '../action-types';
export const formatBadgeContent = (badgeContent) => {
    let formattedBadgeContent = badgeContent || '';
    if (Number(formattedBadgeContent) > 99) {
        formattedBadgeContent = '99+';
    }
    return formattedBadgeContent;
};
const LOOKUP_DIALOG_ID_POSTFIX = '-lookup-dialog';
const getLookupDialogId = (field) => `${field.elementId}${LOOKUP_DIALOG_ID_POSTFIX}`;
export const menuItems = (state = [], action) => produce(state, (nextState) => {
    const addMenuItem = (menuItemToAdd) => {
        const menuItemIndex = state.findIndex(m => m.id === menuItemToAdd.id);
        if (menuItemIndex === -1) {
            // eslint-disable-next-line no-param-reassign
            nextState = state.concat(menuItemToAdd);
        }
        else {
            nextState[menuItemIndex] = { ...menuItemToAdd };
        }
    };
    switch (action.type) {
        case ActionType.AddMenuItem:
            addMenuItem(action.value);
            break;
        case ActionType.UpdateMenuItem:
            const menuItemUpdate = nextState.find(m => m.id === action.value.id);
            if (menuItemUpdate) {
                menuItemUpdate.badgeContent = formatBadgeContent(action.value.badgeContent);
            }
            else {
                xtremConsole.warn(`No menu item was found for ${action.value.id}`);
            }
            break;
        case ActionType.RemoveMenuItem:
            // eslint-disable-next-line no-param-reassign
            nextState = state.filter(m => m.id !== action.value);
            break;
        case ActionType.SetScreenDefinitionDialogId:
            const index = nextState.findIndex(m => m.dialogId === action.value.dialogId);
            nextState[index] = { ...nextState[index], title: action.value.title };
            break;
        case ActionType.OpenLookupDialog:
            addMenuItem({
                alignedLeft: true,
                category: 'dialog-lookup',
                icon: 'cross',
                id: getLookupDialogId(action.value),
                title: action.value.dialogTitle,
                onClick: action.value.onClose,
            });
            break;
        case ActionType.CloseLookupDialog:
            // eslint-disable-next-line no-param-reassign
            nextState = state.filter(m => !m.id.endsWith(LOOKUP_DIALOG_ID_POSTFIX));
            break;
        default:
            break;
    }
    return nextState;
});
//# sourceMappingURL=menu-items.js.map