import produce from 'immer';
import { ActionType } from '../action-types';
export const activeDialogs = (state = {}, action) => produce(state, (nextState) => {
    switch (action.type) {
        case ActionType.OpenDialog:
            nextState[action.value.dialogId] = action.value.dialog;
            break;
        case ActionType.CloseDialog:
            delete nextState[action.value];
            break;
        case ActionType.SetScreenDefinitionDialogId:
            nextState[action.value.dialogId] = {
                ...nextState[action.value.dialogId],
                screenId: action.value.screenId,
                content: action.value.pageControlObject,
                title: action.value.title,
                subtitle: action.value.subtitle,
            };
            break;
        default:
            break;
    }
    return nextState;
});
//# sourceMappingURL=active-dialogs.js.map