import type { Dict } from '@sage/xtrem-shared';
import type { PageDefinition } from '../../service/page-definition';
import type { QueryParameters } from '../../utils/types';
import type { AppAction, AppThunkDispatch } from '../action-types';
import type { XtremAppState } from '../state';
import type { FormattedNodeDetails } from '../../service/metadata-types';
export declare const getPageValues: (screenDefinition: PageDefinition, recordId: string | null, clean?: boolean, nodeTypes?: Dict<FormattedNodeDetails>) => Promise<any>;
export declare const triggerPostNavigationToasts: (state: XtremAppState, path: string, queryParameters: QueryParameters) => Promise<void>;
/**
 * Be aware that base64 encoded parameters in the path will override the queryParameters object
 * @param path Be
 * @param queryParameters
 */
export declare const navigate: (path: string, queryParameters?: QueryParameters) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const selectRecord: (screenId: string, recordId: string | null, clean?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const findNavPanelRecordLocation: (screenId: string, state: XtremAppState, offset: 1 | -1) => Promise<string | null>;
export declare const selectNextRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const selectFirstRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const selectPreviousRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const goHome: () => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const setIdToQueryParameters: (screenId: string, _id: string) => AppAction;
//# sourceMappingURL=router-actions.d.ts.map