import { actions, getStore } from '..';
import { getFieldTitle } from '../../component/field/carbon-helpers';
import { createStickerDialog } from '../../service/dialog-service';
import { triggerScreenEvent } from '../../utils/events';
export const navigationPanelMenuItemId = 'NavigationPanelMenuItem';
export const closeDialogMenuItemId = 'CloseDialogMenuItem';
export const getCloseDialogMenuItem = (dialogId, isDialogSticker, title = 'Close dialog') => ({
    id: closeDialogMenuItemId,
    onClick: () => {
        const dispatch = getStore().dispatch;
        dispatch(actions.closeDialog(dialogId));
    },
    title,
    alignedLeft: true,
    icon: 'cross',
    category: 'dialog',
    isDialogSticker,
    dialogId,
});
export const getStickerMenuItem = (stickerId, icon, sections, badgeContent, title, category) => ({
    icon,
    id: stickerId,
    onClick: () => {
        const section = sections[0];
        const sectionTitle = (section && getFieldTitle(stickerId, section, null)) || '';
        const store = getStore();
        const state = store.getState();
        const existingDialog = Object.values(state.activeDialogs).find(activeDialog => activeDialog.screenId === stickerId);
        if (!existingDialog) {
            triggerScreenEvent(stickerId, 'onOpen');
            createStickerDialog(store, stickerId, 'info', sectionTitle, section, {});
        }
    },
    title: title || stickerId,
    category: category ? `sticker/${category}` : 'sticker',
    badgeContent,
});
//# sourceMappingURL=menu-items.js.map