import { uniq, without } from 'lodash';
import { fetchEnumDefinitions } from '../../service/metadata-service';
import { ActionType } from '../action-types';
export const loadEnumType = (enumNames, locale) => async (dispatch, getState) => {
    const enumsToFetch = without(uniq(enumNames), ...Object.keys(getState().enumTypes));
    const enumDefinitions = await fetchEnumDefinitions(enumsToFetch);
    dispatch({ type: ActionType.AddEnumType, value: { enums: enumDefinitions, locale } });
};
//# sourceMappingURL=enum-types-actions.js.map