import type { Dashboard, Dict } from '@sage/xtrem-shared';
import type { CardDefinition } from '../../component/ui/card/card-component';
import * as dashboardService from '../../service/dashboard-service';
import type { PageDefinition } from '../../service/page-definition';
import type { AppAction, AppThunkDispatch } from '../action-types';
import type { UserWidgetDefinition, XtremAppState } from '../state';
import type { FormattedNodeDetails } from '../../service/metadata-types';
import type { DashboardContextVariables } from '../../dashboard/dashboard-types';
export declare const resetNextWidgetIdOnlyToBeUsedInTests: () => void;
export declare const getWidgetListCardDefinition: (dispatch: AppThunkDispatch, group: string, contextVariables?: DashboardContextVariables) => CardDefinition<any>;
export declare const saveDashboardEditorState: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const createDashboardPageDefinition: (dispatch: AppThunkDispatch, group: string, widgets: dashboardService.XtremUiWidget[], categories: dashboardService.XtremUiWidgetCategory[], contextVariables?: DashboardContextVariables, nodeTypes?: Dict<FormattedNodeDetails>, locale?: string) => PageDefinition;
export declare const openDashboardEditorDialog: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const closeDashboardEditorDialog: (group: string) => AppAction;
export declare const undoDashboardEditor: (group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const redoDashboardEditor: (group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const updateDashboardEditorStateWithHistory: (newDashboardDefinition: Dashboard, group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const removeDashboardEditorWidget: (widgetId: string, group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const updateDashboardTitleInEditor: (newTitle: string, group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
/**
 * Fetches widget source code from the server. It should be called when a new widget is added to the dashboard which has not been previously
 * loaded into the state from the server.
 *
 */
export declare const loadNewWidget: (widgetType: string, widgetId: string, dashboardId: string, group: string, contextVariables?: DashboardContextVariables, settings?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export interface WidgetPosition {
    i: string;
    x: number;
    y: number;
    h: number;
    w: number;
}
export declare const updateDashboardEditorWidgetPositions: (widgets: WidgetPosition[], group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const addNewWidgetToDashboardLayout: (widgetId: string, artifactName: string, group: string, uwd?: UserWidgetDefinition) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const updateWidgetSettings: (widgetId: string, group: string, settings?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const addFunctionalDeveloperDefinedWidget: (widget: dashboardService.XtremUiWidget, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
/**
 * Takes the current working copy of from the widget editor and adds it to the dashboard definition.
 * @returns
 */
export declare const finishEditingUserDefinedWidget: (group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
//# sourceMappingURL=dashboard-editor-actions.d.ts.map